package br.com.softilux.softiluxapp.ui.chamado;

import org.apache.commons.lang3.StringUtils;

import br.com.softilux.core.utils.LoggerUtils;
import br.com.softilux.softiluxapp.R;

/**
 * Created by Vinicius on 31,Janeiro,2019
 */
public enum AndamentoAtendimentoEnum {

    INICIO_DO_CHAMADO("Chamado Iniciado", R.drawable.ic_done_blue_grey_300_24dp, "Confirmar Inicio da Viagem"),
    MARCAR_CHEGADA_NO_CLIENTE("Chegada Cliente", R.drawable.ic_done_blue_grey_300_24dp, "Confirmar Chegada no Cliente"),
    MARCAR_INICIO_ATENDIMENTO_CLIENTE("Inicio Atendimento", R.drawable.ic_done_blue_grey_300_24dp, "Confirmar Inicio de Atendimento"),
    CHAMADO_PAUSADO_ANTES_CHEGAR_NO_CLIENTE("Chamado Pausado", R.drawable.ic_priority_high_blue_grey_300_24dp, ""),
    CHAMADO_PAUSADO_ANTES_DE_INICIAR_ATENDIMENTO("Chamado Pausado", R.drawable.ic_priority_high_blue_grey_300_24dp, ""),
    CHAMADO_PAUSADO_ANTES_DE_FINALIZAR_ATENDIMENTO("Chamado Pausado", R.drawable.ic_priority_high_blue_grey_300_24dp, ""),
    CHAMADO_RETOMADO_ANTES_DE_CHEGADA_CLIENTE("Chamado Retomado", R.drawable.ic_play_circle_outline_blue_grey_300_24dp, ""),
    CHAMADO_RETOMADO_ANTES_DE_INICIAR_ATENDIMENTO("Chamado Retomado", R.drawable.ic_play_circle_outline_blue_grey_300_24dp, ""),
    CHAMADO_RETOMADO_ANTES_DE_FINALIZAR_ATENDIMENTO("Chamado Retomado", R.drawable.ic_play_circle_outline_blue_grey_300_24dp, ""),
    CHAMADO_FINALIZADO("Atendimento Finalizado", R.drawable.ic_done_blue_grey_300_24dp, "Confirmar Finalizar Atendimento"),
    CHAMADO_REINICIADO("Atendimento Reiniciado", R.drawable.ic_done_blue_grey_300_24dp, "");

    /**
     *  Status para ser adicionado a timeline
     *
     * */
    private String status;

    private int image;

    private String title;

    AndamentoAtendimentoEnum(String status, int image, String title) {
        this.status = status;
        this.image = image;
        this.title = title;
    }

    public static AndamentoAtendimentoEnum getEnumFromStatus(String anEnum) {
        if (StringUtils.isNotBlank(anEnum)) {
            for (AndamentoAtendimentoEnum andamentoAtendimento : AndamentoAtendimentoEnum.values()) {
                if (andamentoAtendimento.getStatus().equalsIgnoreCase(anEnum)) {
                    return andamentoAtendimento;
                }
            }
            LoggerUtils.error("Argumento não é valido" + anEnum);
            throw new IllegalArgumentException("Argumento não é valido" + anEnum);
        }

        return null;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public int getImage() {
        return image;
    }

    public void setImage(int image) {
        this.image = image;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }
}
