package br.com.softilux.softiluxapp.ui.base;

import android.content.Context;
import android.content.Intent;
import android.support.annotation.StringRes;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import br.com.softilux.softiluxapp.data.db.model.CurrentChamadoAtendimento;

/**
 * Base interface that any class that wants to act as a View in the MVP (Model View Presenter)
 * pattern must implement. Generally this interface will be extended by a more specific interface
 * that then usually will be implemented by an Activity or Fragment.
 */
public interface MvpView {

    void showLoading();

    void hideLoading();

    void showSpotsDialog();

    void hideSpotsLoading();

    void openActivityOnTokenExpire();

    void onError(@StringRes int resId);

    void onError(String message);

    void showMessage(String message);

    void showMessage(@StringRes int resId);

    void toastyNormal(String message);

    void toastyNormal(@StringRes int resId);

    boolean isNetworkConnected();

    void hideKeyboard();

    void noNetworkConnetedMessage();

    void showDialogErroInterno();

    boolean checkPermissionLocation();

    void atualizarCurrentChamadoAtendimento(@NotNull CurrentChamadoAtendimento currentChamadoAtendimento);

    @Nullable CurrentChamadoAtendimento getCurrentChamadoAtendimento();

}
