package br.com.softilux.softiluxapp.ui.base;

import android.app.Service;
import android.support.annotation.UiThread;

import br.com.softilux.softiluxapp.SoftiluxApp;
import br.com.softilux.softiluxapp.di.component2.ApplicationComponent;
import br.com.softilux.softiluxapp.di.component2.ServiceComponent;
import br.com.softilux.softiluxapp.di.component2.ServiceModule;

public abstract class AbstractBaseService extends Service {

    private boolean mIsServiceComponentUsed;

    @UiThread
    protected ServiceComponent getServiceComponent() {
        if (mIsServiceComponentUsed) {
            throw new RuntimeException("there is no reason to perform injection more than once");
        }

        mIsServiceComponentUsed = true;

        return getApplicationComponent().newServiceComponent(new ServiceModule(this));
    }

    private ApplicationComponent getApplicationComponent() {
        return ((SoftiluxApp) getApplication()).getComponent();
    }
}
