package br.com.softilux.softiluxapp.ui.base;

import android.Manifest;
import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.support.v4.app.Fragment;
import android.view.View;

import com.blankj.utilcode.util.PermissionUtils;

import org.jetbrains.annotations.NotNull;

import br.com.softilux.core.utils.CommonUtils;
import br.com.softilux.core.utils.LoggerUtils;
import br.com.softilux.softiluxapp.R;
import br.com.softilux.softiluxapp.data.db.model.CurrentChamadoAtendimento;
import br.com.softilux.softiluxapp.di.presentation.PresentationComponent;
import butterknife.Unbinder;

public abstract class AbstractBaseFragment extends Fragment implements MvpView {

    private AbstractBaseActivity mActivity;
    private Unbinder mUnBinder;
    private ProgressDialog mProgressDialog;
    private AlertDialog mSpotsDialog;

    @Override
    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
    }

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setHasOptionsMenu(false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        setUp(view);
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        if (context instanceof AbstractBaseActivity) {
            AbstractBaseActivity activity = (AbstractBaseActivity) context;
            this.mActivity = activity;
            activity.onFragmentAttached();
        }
    }

    @Override
    public void showLoading() {
        hideLoading();
        mProgressDialog = CommonUtils.showLoadingDialog(this.getContext());
    }

    @Override
    public void hideLoading() {
        if (mProgressDialog != null && mProgressDialog.isShowing()) {
            mProgressDialog.cancel();
        }
    }

    @Override
    public void showSpotsDialog() {
        hideSpotsLoading();
        mSpotsDialog = CommonUtils.createSpotsLoadingDialog(this.getContext());
        mSpotsDialog.show();
    }

    @Override
    public void hideSpotsLoading() {
        if (mSpotsDialog != null && mSpotsDialog.isShowing()) {
            mSpotsDialog.cancel();
        }
    }

    @Override
    public void onError(String message) {
        if (mActivity != null) {
            mActivity.onError(message);
        }
    }

    @Override
    public void onError(@StringRes int resId) {
        if (mActivity != null) {
            mActivity.onError(resId);
        }
    }

    @Override
    public void showMessage(String message) {
        if (mActivity != null) {
            mActivity.showMessage(message);
        }
    }

    @Override
    public void showMessage(@StringRes int resId) {
        if (mActivity != null) {
            mActivity.showMessage(resId);
        }
    }

    @Override
    public void toastyNormal(String message) {
        if (mActivity != null) {
            mActivity.toastyNormal(message);
        }
    }

    public void mostrarMensagemNecessarioTodasPermissoes() {
        if (mActivity != null) {
            toastyNormal(mActivity.getResources().getString(R.string.permissoes_devem_ser_concedidadas));
        }
    }

    @Override
    public void toastyNormal(int resId) {
        if (mActivity != null) {
            mActivity.toastyNormal(resId);
        }
    }

    @Override
    public boolean isNetworkConnected() {
        if (mActivity != null) {
            return mActivity.isNetworkConnected();
        }
        return false;
    }

    @Override
    public void onDetach() {
        mActivity = null;
        super.onDetach();
    }

    @Override
    public void hideKeyboard() {
        if (mActivity != null) {
            mActivity.hideKeyboard();
        }
    }

    @Override
    public void openActivityOnTokenExpire() {
        if (mActivity != null) {
            mActivity.openActivityOnTokenExpire();
        }
    }

    public PresentationComponent getActivityComponent() {
        if (mActivity != null) {
            return mActivity.getActivityComponent();
        }
        return null;
    }

    @Override
    public boolean checkPermissionLocation() {
        return PermissionUtils.isGranted(Manifest.permission.ACCESS_FINE_LOCATION, Manifest.permission.ACCESS_COARSE_LOCATION);
    }

    public AbstractBaseActivity getBaseActivity() {
        return mActivity;
    }

    public void setUnBinder(Unbinder unBinder) {
        mUnBinder = unBinder;
    }

    protected abstract void setUp(View view);

    @Override
    public void showDialogErroInterno() {
        if (mActivity != null) {
            mActivity.showDialogErroInterno();
        }
    }

    @Override
    public void noNetworkConnetedMessage() {
        if (mActivity != null)
            mActivity.noNetworkConnetedMessage();
    }

    public interface Callback {

        void onFragmentAttached();

        void onFragmentDetached(String tag);

        <T extends AbstractBaseActivity> Intent openActivity(Class<T> calledActivity);
    }

    @Override
    public void atualizarCurrentChamadoAtendimento(@NotNull CurrentChamadoAtendimento currentChamadoAtendimento) {
        if (mActivity!= null) {
            mActivity.atualizarCurrentChamadoAtendimento(currentChamadoAtendimento);
        }
    }

    @Override
    public @org.jetbrains.annotations.Nullable CurrentChamadoAtendimento getCurrentChamadoAtendimento() {
        CurrentChamadoAtendimento currentChamadoAtendimento = null;
        if (mActivity != null) {
            currentChamadoAtendimento = mActivity.getCurrentChamadoAtendimento();
        }
        return currentChamadoAtendimento;
    }

    @Override
    public void onDestroy() {
        if (mUnBinder != null) {
            mUnBinder.unbind();
        }
        hideSpotsLoading();
        hideLoading();
        super.onDestroy();
    }


}
