package br.com.softilux.softiluxapp.ui.base;

import android.app.Dialog;
import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.RelativeLayout;

import org.jetbrains.annotations.NotNull;

import br.com.softilux.softiluxapp.data.db.model.CurrentChamadoAtendimento;
import br.com.softilux.softiluxapp.di.presentation.PresentationComponent;
import butterknife.Unbinder;

public abstract class AbstractBaseDialog extends DialogFragment implements DialogMvpView {

    private AbstractBaseActivity mActivity;
    private Unbinder mUnBinder;

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        if (context instanceof AbstractBaseActivity) {
            AbstractBaseActivity mActivity = (AbstractBaseActivity) context;
            this.mActivity = mActivity;
            mActivity.onFragmentAttached();
        }
    }

    @Override
    public void showLoading() {
        if (mActivity != null) {
            mActivity.showLoading();
        }
    }

    @Override
    public void hideLoading() {
        if (mActivity != null) {
            mActivity.hideLoading();
        }
    }

    @Override
    public void showSpotsDialog() {
        if (mActivity != null) {
            mActivity.showSpotsDialog();
        }
    }

    @Override
    public void hideSpotsLoading() {
        if (mActivity != null) {
            mActivity.hideSpotsLoading();
        }
    }

    @Override
    public void onError(String message) {
        if (mActivity != null) {
            mActivity.onError(message);
        }
    }

    @Override
    public void onError(@StringRes int resId) {
        if (mActivity != null) {
            mActivity.onError(resId);
        }
    }

    @Override
    public void showMessage(String message) {
        if (mActivity != null) {
            mActivity.showMessage(message);
        }
    }

    @Override
    public void showMessage(@StringRes int resId) {
        if (mActivity != null) {
            mActivity.showMessage(resId);
        }
    }

    @Override
    public void toastyNormal(String message) {
        if (mActivity != null) {
            mActivity.toastyNormal(message);
        }
    }

    @Override
    public void toastyNormal(int resId) {
        if (mActivity != null) {
            mActivity.toastyNormal(resId);
        }
    }

    @Override
    public boolean isNetworkConnected() {
        if (mActivity != null) {
            return mActivity.isNetworkConnected();
        }
        return false;
    }

    @Override
    public void onDetach() {
        mActivity = null;
        super.onDetach();
    }

    @Override
    public void hideKeyboard() {
        if (mActivity != null) {
            mActivity.hideKeyboard();
        }
    }

    @Override
    public void openActivityOnTokenExpire() {
        if (mActivity != null) {
            mActivity.openActivityOnTokenExpire();
        }
    }

    public AbstractBaseActivity getBaseActivity() {
        return mActivity;
    }

    public PresentationComponent getActivityComponent() {
        if (mActivity != null) {
            return mActivity.getActivityComponent();
        }
        return null;
    }

    public void setUnBinder(Unbinder unBinder) {
        mUnBinder = unBinder;
    }

    protected abstract void setUp(View view);

    @NonNull
    @Override
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        // the content
        final RelativeLayout root = new RelativeLayout(getActivity());
        root.setLayoutParams(new ViewGroup.LayoutParams(
                ViewGroup.LayoutParams.MATCH_PARENT,
                ViewGroup.LayoutParams.WRAP_CONTENT));

        // creating the fullscreen dialog
        final Dialog dialog = new Dialog(getContext());
        dialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
        dialog.setContentView(root);
        if (dialog.getWindow() != null) {
            dialog.getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
            dialog.getWindow().setLayout(
                    ViewGroup.LayoutParams.MATCH_PARENT,
                    ViewGroup.LayoutParams.WRAP_CONTENT);
        }
        dialog.setCanceledOnTouchOutside(false);

        return dialog;
    }

    @Override
    public void onViewCreated(@NotNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        setUp(view);
    }

    public void show(FragmentManager fragmentManager, String tag) {
        FragmentTransaction transaction = fragmentManager.beginTransaction();
        Fragment prevFragment = fragmentManager.findFragmentByTag(tag);
        if (prevFragment != null) {
            transaction.remove(prevFragment);
        }
        transaction.addToBackStack(null);
        show(transaction, tag);
    }

    @Override
    public void dismissDialog(String tag) {
        dismiss();
        getBaseActivity().onFragmentDetached(tag);
    }

    @Override
    public void noNetworkConnetedMessage() {
        if (mActivity != null)
            mActivity.noNetworkConnetedMessage();
    }

    @Override
    public void showDialogErroInterno() {
        if (mActivity != null)
            mActivity.showDialogErroInterno();
    }

    @Override
    public boolean checkPermissionLocation() {
        if (mActivity != null)
            return mActivity.checkPermissionLocation();
        return false;
    }

    @Override
    public void onDestroy() {
        if (mUnBinder != null) {
            mUnBinder.unbind();
        }
        super.onDestroy();
    }

    @Override
    public void atualizarCurrentChamadoAtendimento(@NotNull CurrentChamadoAtendimento currentChamadoAtendimento) {
        if(mActivity != null) {
            mActivity.atualizarCurrentChamadoAtendimento(currentChamadoAtendimento);
        }
    }

    @Override
    public @org.jetbrains.annotations.Nullable CurrentChamadoAtendimento getCurrentChamadoAtendimento() {
        CurrentChamadoAtendimento currentChamadoAtendimento = null;
        if (mActivity != null) {
            currentChamadoAtendimento = mActivity.getCurrentChamadoAtendimento();
        }
        return currentChamadoAtendimento;
    }
}