package br.com.softilux.softiluxapp.ui.base;

import android.Manifest;
import android.annotation.TargetApi;
import android.app.AlertDialog;
import android.app.Dialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.location.Address;
import android.location.Geocoder;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.provider.Settings;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.support.design.widget.Snackbar;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.TextView;
import android.widget.Toast;

import com.blankj.utilcode.util.NetworkUtils;
import com.blankj.utilcode.util.PermissionUtils;
import com.google.gson.Gson;

import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

import java.io.IOException;
import java.util.List;
import java.util.Locale;

import javax.inject.Inject;

import br.com.softilux.core.utils.CommonUtils;
import br.com.softilux.core.utils.GeocoderUtils;
import br.com.softilux.core.utils.LoggerUtils;
import br.com.softilux.core.utils.dialogs.DialogsManager;
import br.com.softilux.core.utils.dialogs.PermissaoCameraDialogFragment;
import br.com.softilux.core.utils.dialogs.PermissaoLocalidadeDialogFragment;
import br.com.softilux.core.utils.dialogs.PermissaoStorageDialogFragment;
import br.com.softilux.core.utils.dialogs.ServerErrorDialogFragment;
import br.com.softilux.softiluxapp.R;
import br.com.softilux.softiluxapp.SoftiluxApp;
import br.com.softilux.softiluxapp.data.dao.ConfigDAO;
import br.com.softilux.softiluxapp.data.db.model.CurrentChamadoAtendimento;
import br.com.softilux.softiluxapp.data.db.model.UsuarioLogado;
import br.com.softilux.softiluxapp.data.nosql.IPaperBook;
import br.com.softilux.softiluxapp.di.component2.ApplicationComponent;
import br.com.softilux.softiluxapp.di.presentation.PresentationComponent;
import br.com.softilux.softiluxapp.di.presentation.PresentationModule;
import br.com.softilux.softiluxapp.ui.chamado.ChamadoManutencaoActivityJava;
import br.com.softilux.softiluxapp.ui.login.LoginActivity;
import butterknife.Unbinder;
import es.dmoral.toasty.Toasty;
import uk.co.chrisjenx.calligraphy.CalligraphyContextWrapper;

//import br.com.softilux.softiluxapp.di.component.ActivityComponent;
//import br.com.softilux.softiluxapp.di.module.ActivityModule;

public abstract class AbstractBaseActivity extends AppCompatActivity implements MvpView, ActivityView, AbstractBaseFragment.Callback {

    @Inject
    ConfigDAO configDAO;

    @Inject
    Gson gson;

    @Inject
    IPaperBook iPaperBook;

    @Inject
    DialogsManager mDialogsManager;

    /**
     * Usuario logado na aplicacao
     * */
    private UsuarioLogado usuarioLogado;

    /**
     * Progress dialog para ser exibido em tela
     * */
    private ProgressDialog mProgressDialog;

    //private ActivityComponent mActivityComponent;

    private PresentationComponent presentationComponent;

    private Unbinder mUnBinder;

    private AlertDialog mSpotsDialog;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

//        mActivityComponent = DaggerActivityComponent.builder()
//                .activityModule(new ActivityModule(this))
//                .applicationComponent(((SoftiluxApp) getApplication()).getComponent())
//                .build();

        presentationComponent = getApplicationComponent()
                .newPresentationComponent(new PresentationModule(this));
    }

    private ApplicationComponent getApplicationComponent() {
        return ((SoftiluxApp) getApplication()).getComponent();
    }

    public PresentationComponent getActivityComponent() {
        return presentationComponent;
    }

    @Override
    protected void attachBaseContext(Context newBase) {
        ContextWrapper wrap = CalligraphyContextWrapper.wrap(newBase);
        super.attachBaseContext(newBase);
    }

    @TargetApi(Build.VERSION_CODES.M)
    public void requestPermissionsSafely(String[] permissions, int requestCode) {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
            requestPermissions(permissions, requestCode);
        }
    }

    @TargetApi(Build.VERSION_CODES.M)
    public boolean hasPermission(String permission) {
        return Build.VERSION.SDK_INT < Build.VERSION_CODES.M || checkSelfPermission(permission) == PackageManager.PERMISSION_GRANTED;
    }

    @Override
    public void showLoading() {
        hideLoading();
        mProgressDialog = CommonUtils.showLoadingDialog(this);
    }

    @Override
    public void showSpotsDialog() {
        hideSpotsLoading();
        mSpotsDialog = CommonUtils.createSpotsLoadingDialog(this);
        mSpotsDialog.show();
    }

    @Override
    public void hideSpotsLoading() {
        if (mSpotsDialog != null && mSpotsDialog.isShowing()) {
            mSpotsDialog.cancel();
        }
    }

    @Override
    public void hideLoading() {
        if (mProgressDialog != null && mProgressDialog.isShowing()) {
            mProgressDialog.cancel();
        }
    }

    private void showSnackBar(String message) {
        Snackbar snackbar = Snackbar.make(findViewById(android.R.id.content), message, Snackbar.LENGTH_SHORT);
        View sbView = snackbar.getView();
        TextView textView = sbView.findViewById(android.support.design.R.id.snackbar_text);
        textView.setTextColor(ContextCompat.getColor(this, R.color.white));
        snackbar.show();
    }

    @Override
    public void onError(String message) {
        if (message != null) {
            showSnackBar(message);
        } else {
            showSnackBar(getString(R.string.some_error));
        }
    }

    @Override
    public void onError(@StringRes int resId) {
        onError(getString(resId));
    }

    @Override
    public void showMessage(String message) {
        if (message != null) {
            Toast.makeText(this, message, Toast.LENGTH_SHORT).show();
        } else {
            Toast.makeText(this, getString(R.string.erro_comunicao_servidor), Toast.LENGTH_SHORT).show();
        }
    }

    @Override
    public void showMessage(@StringRes int resId) {
        showMessage(getString(resId));
    }

    @Override
    public void toastyNormal(String message) {
        if (StringUtils.isNotBlank(message)) {
            Toasty.normal(this, message, Toasty.LENGTH_SHORT).show();
        } else {
            Toasty.normal(this, getString(R.string.erro_comunicao_servidor), Toasty.LENGTH_SHORT).show();
        }
    }

    @Override
    public void toastyNormal(int resId) {
        toastyNormal(getString(resId));
    }

    @Override
    public boolean isNetworkConnected() {
        return NetworkUtils.isConnected();
    }

    @Override
    public void onFragmentAttached() {

    }

    @Override
    public void onFragmentDetached(String tag) {

    }

    public void hideKeyboard() {
        View view = this.getCurrentFocus();
        if (view != null) {
            InputMethodManager imm = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
            imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
        }
    }

    public void hideKeyboard(Dialog dialog) {
        View currentFocus = dialog.getCurrentFocus();
        if (currentFocus != null) {
            InputMethodManager imm = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
            imm.hideSoftInputFromWindow(currentFocus.getWindowToken(), 0);
        }
    }

    public void hideKeyboard(View view) {
        if (view != null) {
            InputMethodManager imm = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
            imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
        }
    }

    @Override
    public void openActivityOnTokenExpire() {
        startActivity(LoginActivity.getStartIntent(this));
        finish();
    }

    public void setUnBinder(Unbinder unBinder) {
        mUnBinder = unBinder;
    }

    @Override
    protected void onDestroy() {
        if (mUnBinder != null) {
            mUnBinder.unbind();
        }
        hideLoading();
        hideSpotsLoading();
        super.onDestroy();
    }

    protected abstract void setUp();

    //protected abstract void registerObservers();

    /**
     * Overrides the pending Activity transition by performing the "Enter" animation.
     */
    protected void overridePendingTransitionEnter() {
        overridePendingTransition(R.anim.slide_from_right, R.anim.slide_to_left);
    }

    /**
     * Overrides the pending Activity transition by performing the "Exit" animation.
     */
    protected void overridePendingTransitionExit() {
        overridePendingTransition(R.anim.slide_from_left, R.anim.slide_to_right);
    }

    public UsuarioLogado getLoggedUser() {
        if (usuarioLogado == null)
            usuarioLogado = iPaperBook.getUsuarioLogado();
        return usuarioLogado;
    }

    @Override
    public void noNetworkConnetedMessage() {
        String string = getString(R.string.network_off);
        toastyNormal(string);
    }

    public <T extends AbstractBaseActivity> Intent openActivity(Class<T> calledActivity) {
        return new Intent(this, calledActivity);
    }

    public <T extends AbstractBaseActivity> Intent openActivity(Context context, Class<T> calledActivity) {
        return new Intent(context, calledActivity);
    }

    public void invisibleView(View view) {
        view.setVisibility(View.INVISIBLE);
    }

    public void goneView(View view) {
        view.setVisibility(View.GONE);
    }

    public void visibleView(View view) {
        view.setVisibility(View.VISIBLE);
    }

    public void showDialogPermissaoLocalidade() {
        mDialogsManager.showRetainedDialogWithId(PermissaoLocalidadeDialogFragment.newInstance(), "");
    }

    public void showDialogPermissaoCamera() {
        mDialogsManager.showRetainedDialogWithId(PermissaoCameraDialogFragment.newInstance(), "");
    }

    public void showDialogPermissaoStorage() {
        mDialogsManager.showRetainedDialogWithId(PermissaoStorageDialogFragment.newInstance(), "");
    }

    @Override
    public void showDialogErroInterno() {
        mDialogsManager.showRetainedDialogWithId(ServerErrorDialogFragment.newInstance(), "");
    }

    public void showSettingsDialogLocalidade() {
        android.support.v7.app.AlertDialog.Builder builder = new android.support.v7.app.AlertDialog.Builder(this, R.style.AlertDialogTheme);
        builder.setTitle(getString(R.string.permissao_necessaria));
        builder.setMessage(getString(R.string.permissao_localidade_necessaria));
        builder.setPositiveButton("Settings", new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                dialog.cancel();
                openSettings();
            }
        });
        builder.setNegativeButton(getString(R.string.cancelar), new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                dialog.cancel();
            }
        });
        android.support.v7.app.AlertDialog alertDialog = builder.create();
        alertDialog.show();
    }

    // navigating user to app settings
    public void openSettings() {
        Intent intent = new Intent(Settings.ACTION_APPLICATION_DETAILS_SETTINGS);
        Uri uri = Uri.fromParts("package", getPackageName(), null);
        intent.setData(uri);
        startActivityForResult(intent, 101);
    }

    @Override
    public boolean checkPermissionLocation() {
        return PermissionUtils.isGranted(Manifest.permission.ACCESS_FINE_LOCATION, Manifest.permission.ACCESS_COARSE_LOCATION);
    }

    @Override
    public void atualizarCurrentChamadoAtendimento(@Nullable CurrentChamadoAtendimento currentChamadoAtendimento) {
        iPaperBook.salvarCurrentAtendimento(currentChamadoAtendimento);
    }

    public void clearCurrentChamadoAtendimento() {
        LoggerUtils.d(this.getClass().getSimpleName() + " limpando current");
        iPaperBook.clearCurrentChamadoAtendimento();
    }

    @Override
    public @org.jetbrains.annotations.Nullable CurrentChamadoAtendimento getCurrentChamadoAtendimento() {
        CurrentChamadoAtendimento currentAtendimento = iPaperBook.getCurrentAtendimento();
        LoggerUtils.d(this.getClass().getSimpleName() + " getCurrentChamadoAtendimento()" + gson.toJson(currentAtendimento));
        return currentAtendimento;
    }

    public Address getAddress(Context context, double latitude, double longitude)  {
        return GeocoderUtils.getAddress(latitude, longitude, context);
    }
}
