package br.com.softilux.softiluxapp.ui.atendimento;

import android.content.Context;
import android.databinding.DataBindingUtil;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.ViewGroup;

import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;

import br.com.softilux.softiluxapp.R;
import br.com.softilux.softiluxapp.databinding.TimelineItemRowBinding;
import br.com.softilux.core.base.AbstractBaseViewHolder;
import br.com.softilux.softiluxapp.ui.chamado.TimeLineChamado;

/**
 * Created by Vinicius on 14,Fevereiro,2019
 */
public class TimeLineAdapter extends RecyclerView.Adapter<TimeLineAdapter.TimeLineVH> {

    private final Context mContext;
    private final List<TimeLineChamado> mDataSet;

    public TimeLineAdapter(final Context context,
                           List<TimeLineChamado> timeLines) {
        this.mContext = context;
        this.mDataSet = timeLines;
    }

    @NonNull
    @Override
    public TimeLineVH onCreateViewHolder(@NonNull ViewGroup parent, int i) {
        LayoutInflater inflater = LayoutInflater.from(mContext);
        TimelineItemRowBinding binding = DataBindingUtil.inflate(inflater, R.layout.timeline_item_row, parent, false);
        return new TimeLineVH(binding);
    }

    @Override
    public void onBindViewHolder(@NonNull TimeLineVH timeLineVH, int position) {
        timeLineVH.bindData(mDataSet.get(position));
    }

    @Override
    public int getItemCount() {
        return mDataSet.size();
    }

    public class TimeLineVH extends AbstractBaseViewHolder<TimeLineChamado> {

        private final TimelineItemRowBinding binding;

        public TimeLineVH(TimelineItemRowBinding binding) {
            super(binding.getRoot());
            this.binding = binding;
        }

        @Override
        public void bindData(TimeLineChamado model) {
            super.bindData(model);
            binding.tvMotivoTitle.setText(model.getAndamentoChamadoEnum().getStatus());
            binding.tvMotivoDescription.setText(model.getMotivo());
            binding.tvHora.setText(new SimpleDateFormat("HH:mm", new Locale("pt","BR")).format(model.getDataRegistro()));
            binding.ivStatusMotivo.setImageResource(model.getAndamentoChamadoEnum().getImage());
        }

    }
}
