package br.com.softilux.softiluxapp.ui.atendimento;

import android.content.Context;
import android.content.Intent;
import android.databinding.DataBindingUtil;
import android.os.Bundle;
import android.support.v7.widget.LinearLayoutManager;

import org.apache.commons.collections4.CollectionUtils;

import java.text.SimpleDateFormat;
import java.util.Locale;

import br.com.softilux.softiluxapp.R;
import br.com.softilux.softiluxapp.databinding.ActivityDetalhesAtendimentoBinding;
import br.com.softilux.softiluxapp.ui.base.AbstractBaseActivity;
import br.com.softilux.softiluxapp.ui.chamado.AtendimentoChamado;
import br.com.softilux.softiluxapp.ui.chamado.ChamadosStatic;
import br.com.softilux.softiluxapp.ui.chamado.finalizar.MoneyTextWatcher;
import br.com.softilux.softiluxapp.ui.chamado.imagens.ImagemAdapterJava;
import br.com.softilux.softiluxapp.ui.chamado.imagens.ImagemClickListener;
import br.com.softilux.softiluxapp.ui.solicitacoes.NovaSolicitacaoAdapter;
import br.com.softilux.softiluxapp.ui.solicitacoes.SolicitacaoClickListener;
import br.com.softilux.softiluxapp.ui.solicitacoes.SolicitacaoPecaModel;
import br.com.softilux.core.utils.constants.AppConstants;

public class DetalhesAtendimentoActivity extends AbstractBaseActivity {

    private ActivityDetalhesAtendimentoBinding binding;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        binding = DataBindingUtil.setContentView(this, R.layout.activity_detalhes_atendimento);
        getActivityComponent().inject(this);
        setUp();
    }

    public static Intent getStartIntent(Context context) {
        return new Intent(context, DetalhesAtendimentoActivity.class);
    }

    private Long getIdChamado() {
        Long chamadoAtivo = null;
        if (getIntent().getExtras() != null)
            chamadoAtivo = getIntent().getExtras().getLong(AppConstants.CHAMADO_ID, 0L);
        return chamadoAtivo;
    }

    private Long getIdAtendimento() {
        Long atendimento = null;
        if (getIntent().getExtras() != null)
            atendimento = getIntent().getExtras().getLong(AppConstants.ATENDIMENTO_ID, 0L);
        return atendimento;
    }

    @Override
    protected void setUp() {
        ChamadosStatic pesquisar = ChamadosStatic.pesquisar(getIdChamado());
        if (pesquisar.getAtendimentos().get(getIdAtendimento()) != null) {
            AtendimentoChamado atendimentoChamado = pesquisar.getAtendimentos().get(getIdAtendimento());

            if (atendimentoChamado != null) {
                setSupportActionBar(binding.toolbar);
                if (getSupportActionBar() != null) {
                    getSupportActionBar().setDisplayHomeAsUpEnabled(true);
                    getSupportActionBar().setTitle("Atendimento "+ atendimentoChamado.getId());
                }
                binding.tvAcao.setText(atendimentoChamado.getAcao());
                binding.tvCausa.setText(atendimentoChamado.getCausa());
                binding.tvPlacaVeiculo.setText(atendimentoChamado.getPlacaVeiculo());
                binding.tvKmInicial.setText(String.valueOf(atendimentoChamado.getKmInicial()));
                if (atendimentoChamado.getKmFinal() > 0)
                    binding.tvKmFinal.setText(String.valueOf(atendimentoChamado.getKmFinal()));
                binding.tvCopiasDescontadas.setText(String.valueOf(atendimentoChamado.getCopiasDescontadas()));
                if (atendimentoChamado.getDataAceiteChamado() != null) {
                    binding.tvDtAceiteChamado.setText(new SimpleDateFormat("dd/MM/yyyy HH:mm", new Locale("pt", "BR"))
                            .format(atendimentoChamado.getDataAceiteChamado()));
                }
                if (atendimentoChamado.getDataFinalChamado() != null) {
                    binding.tvDtFinalAtendimento.setText(new SimpleDateFormat("dd/MM/yyyy HH:mm", new Locale("pt", "BR"))
                            .format(atendimentoChamado.getDataFinalChamado()));
                }
                binding.tvFollowUp.setText(atendimentoChamado.getFollowUpTecnico());
                binding.tvMedidor.setText(atendimentoChamado.getMedidor());
                binding.tvTipoStatus.setText(atendimentoChamado.getTipoStatus());
                binding.tvObservacao.setText(atendimentoChamado.getObservacao());
                binding.tvSintoma.setText(atendimentoChamado.getSintoma());
                binding.tvValorMedidor.setText(String.valueOf(atendimentoChamado.getValorMedidor()));
                if (atendimentoChamado.getValorEstacionamento() != null)
                    binding.tvValorEstacionamento.setText(MoneyTextWatcher.mask(atendimentoChamado.getValorEstacionamento()));
                if (atendimentoChamado.getValorPedagio() != null)
                    binding.tvValorPedagio.setText(MoneyTextWatcher.mask(atendimentoChamado.getValorPedagio()));
                if (atendimentoChamado.getOutrosValores() != null)
                    binding.tvOutrosValores.setText(MoneyTextWatcher.mask(atendimentoChamado.getOutrosValores()));
                binding.tvNomeContato.setText(atendimentoChamado.getNomeContato());

                updateTimeline(atendimentoChamado);
                //updateFotos(atendimentoChamado);
                updatePecas(atendimentoChamado);
            }

        }
    }

    private void updatePecas(AtendimentoChamado atendimentoChamado) {
        if (CollectionUtils.isNotEmpty(atendimentoChamado.getPecasSolicitadas())) {
            binding.rvPecas.setLayoutManager(new LinearLayoutManager(DetalhesAtendimentoActivity.this));
           // binding.rvPecas.setNestedScrollingEnabled(false);
            binding.rvPecas.setHasFixedSize(true);
            NovaSolicitacaoAdapter novaSolicitacaoAdapter = new NovaSolicitacaoAdapter(DetalhesAtendimentoActivity.this,
                    atendimentoChamado.getPecasSolicitadas(),
                    new SolicitacaoClickListener() {
                @Override
                public void onItemClick(SolicitacaoPecaModel solicitacaoPecaModel) {
                    // --
                }
            });
            binding.rvPecas.setAdapter(novaSolicitacaoAdapter);
        }
    }

//    private void updateFotos(AtendimentoChamado atendimentoChamado) {
//        if (CollectionUtils.isNotEmpty(atendimentoChamado.getFotosEquipamento())) {
//            binding.rvEquipamentos.setLayoutManager(new LinearLayoutManager(DetalhesAtendimentoActivity.this));
//            ImagemAdapterJava imagemAdapterJava = new ImagemAdapterJava(DetalhesAtendimentoActivity.this,
//                    atendimentoChamado.getFotosEquipamento(),
//                    new ImagemClickListener() {
//                @Override
//                public void onItemClick(String s) {
//                    //
//                }
//            });
//            binding.rvEquipamentos.setAdapter(imagemAdapterJava);
//        }
//    }

    private void updateTimeline(AtendimentoChamado atendimentoChamado) {
        if (CollectionUtils.isNotEmpty(atendimentoChamado.getAlteracoesChamado())) {
            binding.rvTimeLines.setLayoutManager(new LinearLayoutManager(DetalhesAtendimentoActivity.this));
            //binding.rvTimeLines.setNestedScrollingEnabled(false);
            TimeLineAdapter timeLineAdapter = new TimeLineAdapter(DetalhesAtendimentoActivity.this,
                    atendimentoChamado.getAlteracoesChamado());
            binding.rvTimeLines.setAdapter(timeLineAdapter);
        }
    }

}
