package br.com.softilux.softiluxapp.ui.assinatura;

import javax.inject.Inject;

import br.com.softilux.softiluxapp.data.DataManager;
import br.com.softilux.softiluxapp.data.dao.ConfigDAO;
import br.com.softilux.softiluxapp.ui.base.BasePresenter;
import br.com.softilux.softiluxapp.ui.chamado.ChamadoManutencaoMvpPresenter;
import br.com.softilux.softiluxapp.ui.chamado.ChamadoManutencaoMvpView;
import br.com.softilux.softiluxapp.utils.rx.SchedulerProvider;
import io.reactivex.disposables.CompositeDisposable;

public class AssinaturaPresenter <V extends AssinaturaMvpView> extends BasePresenter<V>
        implements AssinaturaMvpPresenter<V> {

    @Inject
    public AssinaturaPresenter(DataManager dataManager,
                               SchedulerProvider schedulerProvider,
                               CompositeDisposable compositeDisposable,
                               ConfigDAO configDAO) {
        super(dataManager, schedulerProvider, compositeDisposable, configDAO);
    }

    @Override
    public void onClickSalvarAssinatura() {
        getMvpView().openMainActivity();
    }
}
