package br.com.softilux.softiluxapp.ui.assinatura;

import android.Manifest;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.databinding.DataBindingUtil;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.location.Address;
import android.location.Location;
import android.os.Bundle;
import android.os.Environment;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.support.v7.app.AlertDialog;
import android.util.AttributeSet;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.Toast;

import com.blankj.utilcode.util.TimeUtils;
import com.google.android.gms.location.FusedLocationProviderClient;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.tasks.OnFailureListener;

import org.jetbrains.annotations.NotNull;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

import javax.inject.Inject;

import br.com.softilux.core.utils.DateUtils;
import br.com.softilux.core.utils.LoggerUtils;
import br.com.softilux.core.webservice.ResponseTransfer;
import br.com.softilux.softiluxapp.R;
import br.com.softilux.softiluxapp.data.dao.AmazonPhotoDAO;
import br.com.softilux.softiluxapp.data.dao.AtendimentoDAO;
import br.com.softilux.softiluxapp.data.dao.ChamadoDAO;
import br.com.softilux.softiluxapp.data.dao.TimelineDAO;
import br.com.softilux.softiluxapp.data.db.model.AmazonFileModel;
import br.com.softilux.softiluxapp.data.db.model.AtendimentoModel;
import br.com.softilux.softiluxapp.data.db.model.ChamadoModel;
import br.com.softilux.softiluxapp.data.db.model.CurrentChamadoAtendimento;
import br.com.softilux.softiluxapp.data.db.model.LocationCapture;
import br.com.softilux.softiluxapp.data.db.model.TimelineModel;
import br.com.softilux.softiluxapp.data.db.model.TipoInclusaoTimeLine;
import br.com.softilux.softiluxapp.data.db.model.representation.StatusChamado;
import br.com.softilux.softiluxapp.data.db.model.representation.TipoFoto;
import br.com.softilux.softiluxapp.databinding.ActivityAssinaturaBinding;
import br.com.softilux.softiluxapp.transfer.datatransfer.CadastrarNovaTimelineNetworkingRequest;
import br.com.softilux.softiluxapp.transfer.datatransfer.finalizaratendimento.Atendimento;
import br.com.softilux.softiluxapp.transfer.datatransfer.finalizaratendimento.FinalizarAtendimentoRequestDTO;
import br.com.softilux.softiluxapp.transfer.datatransfer.finalizaratendimento.FinalizarAtendimentoResponseDTO;
import br.com.softilux.softiluxapp.transfer.datatransfer.finalizaratendimento.Timeline;
import br.com.softilux.softiluxapp.transfer.services.IAtendimentoService;
import br.com.softilux.softiluxapp.transfer.services.IFileService;
import br.com.softilux.softiluxapp.transfer.services.TimelineRequestResponse;
import br.com.softilux.softiluxapp.ui.base.AbstractBaseActivity;
import br.com.softilux.softiluxapp.ui.chamado.AndamentoAtendimentoEnum;
import br.com.softilux.softiluxapp.ui.main.MainActivity3;
import br.com.softilux.softiluxapp.utils.rx.SchedulerProvider;
import io.reactivex.disposables.CompositeDisposable;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import timber.log.Timber;

;

public class AssinaturaActivity extends AbstractBaseActivity implements AssinaturaMvpView {

    @Inject
    AssinaturaMvpPresenter<AssinaturaMvpView> mPresenter;

    Button mClear, mGetSign;

    File file;

    LinearLayout mContent;

    View view;

    Signature mSignature;

    Bitmap bitmap;

    @Inject
    AtendimentoDAO mAtendimentoDAO;

    @Inject
    TimelineDAO mTimelineDAO;

    @Inject
    ChamadoDAO mChamadoDAO;


    @Inject
    CompositeDisposable compositeDisposable;

    @Inject
    SchedulerProvider schedulerProvider;

    @Inject
    IFileService mFileService;

    @Inject
    AmazonPhotoDAO mAmazonPhotoDAO;

    @Inject
    IAtendimentoService mAtendimentoService;

    // Creating Separate Directory for saving Generated Images
    String DIRECTORY = Environment.getExternalStorageDirectory().getPath() + "/Softilux/UserSignature/";

    String pic_name = new SimpleDateFormat("yyyyMMdd_HHmmss", Locale.getDefault()).format(new Date());

    String StoredPath = DIRECTORY + pic_name + ".png";

    ActivityAssinaturaBinding binding;

    boolean mHasAssinature = false;

    public static Intent getStartIntent(Context context) {
        Intent intent = new Intent(context, AssinaturaActivity.class);
        return intent;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        binding = DataBindingUtil.setContentView(this, R.layout.activity_assinatura);
        getActivityComponent().inject(this);
        mPresenter.onAttach(this);
        setUp();
    }

    @Override
    protected void setUp() {
        mContent = findViewById(R.id.canvasLayout);
        mSignature = new Signature(getApplicationContext(), null);
        mSignature.setBackgroundColor(Color.WHITE);
        // Dynamically generating Layout through java code
        mContent.addView(mSignature, ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT);
        mClear = findViewById(R.id.clear);
        mGetSign = findViewById(R.id.getsign);
        //mGetSign.setEnabled(false);
        view = mContent;
        mGetSign.setOnClickListener(onButtonClick);
        mClear.setOnClickListener(onButtonClick);

        // Method to create Directory, if the Directory doesn't exists
        file = new File(DIRECTORY);
        if (!file.exists()) {
            file.mkdir();
        }
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        return super.onOptionsItemSelected(item);
    }

    Button.OnClickListener onButtonClick = new Button.OnClickListener() {
        @Override
        public void onClick(View v) {
            // TODO Auto-generated method stub
            if (v == mClear) {
                Timber.tag("log_tag").v("Panel Cleared");
                mSignature.clear();
                //mGetSign.setEnabled(false);
            } else if (v == mGetSign) {
                Timber.tag("log_tag").v("Panel Saved");
                if (!mHasAssinature || isStoragePermissionGranted()) {
                    alertContinueAssinature();
                }
            }
        }
    };

    private void alertContinueAssinature() {
        AlertDialog.Builder builder = new AlertDialog.Builder(this, R.style.AlertDialogTheme);
        builder.setTitle("Confirmar");

        StringBuilder stringBuilder = new StringBuilder();
        if (!mHasAssinature) {
            stringBuilder.append("Assinatura não informada! ");
            stringBuilder.append("Deseja continuar?");
        } else {
            stringBuilder.append("Deseja continuar com a assinatura informada?");
        }

        builder.setMessage(stringBuilder.toString());

        builder.setPositiveButton("Sim", new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                mPresenter.onClickSalvarAssinatura();
            }
        });

        builder.setNegativeButton("Não", new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        });

        AlertDialog alertDialog = builder.create();
        alertDialog.show();
    }

    public void sincronizePhotoWithServer(File file) {

//            MediaStore.Images.Media.insertImage(getBaseActivity().getContentResolver(), file.getAbsolutePath(), file.getName(), null);
//            getBaseActivity().sendBroadcast(new Intent(Intent.ACTION_MEDIA_SCANNER_SCAN_FILE, Uri.fromFile(file)));

        RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), file);

        // MultipartBody.Part is used to send also the actual file name
        MultipartBody.Part body = MultipartBody.Part.createFormData("image", file.getName(), requestFile);

        LoggerUtils.info("" + body);

        CurrentChamadoAtendimento currentChamadoAtendimento = getCurrentChamadoAtendimento();
        AtendimentoModel atendimentoModel = currentChamadoAtendimento.getAtendimentoModel();

        if (!isNetworkConnected()) {
            noNetworkConnetedMessage();
            return;
        }

        // add another part within the multipart request
        RequestBody tipo = RequestBody.create(MediaType.parse("multipart/form-data"), TipoFoto.ASSINATURA_CLIENTE.getTipoFoto());


        compositeDisposable.add(mFileService.uploadImage(tipo, body, atendimentoModel.getIdAtendimentoPortal(), atendimentoModel.getIdBase())
                .observeOn(schedulerProvider.ui())
                .subscribeOn(schedulerProvider.io())
                .doOnSubscribe(d -> showLoading())
                .subscribe(
                        result -> {
                            LoggerUtils.info("Resultado foi: " + result);
                            if (result.hasData()) {
                                AmazonFileModel amazonFileModel = AmazonFileModel.gerarNovoAmazonFileFotoEquipamento(result.getData(), atendimentoModel);
                                LoggerUtils.info("" + amazonFileModel.getTipoFoto());
                                long insert = mAmazonPhotoDAO.insert(amazonFileModel);
                                AmazonFileModel byIdApp = mAmazonPhotoDAO.findByIdApp(insert);
                                atendimentoModel.getPhotos().add(byIdApp);
                                atualizarCurrentChamadoAtendimento(currentChamadoAtendimento);
                                finalizarAtendimento();
                            }
                        },
                        throwable ->  {
                            hideLoading();
                            LoggerUtils.error(throwable, this.getClass().getSimpleName());
                            showDialogErroInterno();
                        }, this::hideLoading
                ));
    }

    @NotNull
    private CadastrarNovaTimelineNetworkingRequest cadastrarNovaTimelineNetworkingRequest(AndamentoAtendimentoEnum andamento, String motivo, String motivoOutros, AtendimentoModel atendimentoModel, Location lastLocation) {
        CadastrarNovaTimelineNetworkingRequest request = new CadastrarNovaTimelineNetworkingRequest();
        // ------------------------------ Preencher dados da nova timeline
        request.setCreateAt(DateUtils.formatYyyyMMddHHmmss(TimeUtils.getNowDate()));
        request.setTipoTimeLine(TipoInclusaoTimeLine.INCLUSAO_PROGRESSO_APP);
        request.setAndamentoSnapshot(andamento);
        request.setMotivo(motivo);
        request.setMotivoOutros(motivoOutros);
        request.setIdTecnico(atendimentoModel.getNomeAtendente());
        request.setIdAtendimentoPortal(atendimentoModel.getIdAtendimentoPortal());
        request.setIdBase(atendimentoModel.getIdBase());

        // ------------------------------ Preencher localizacao
        LocationCapture locationCapture = getLocationCapture(lastLocation);
        LoggerUtils.info(locationCapture.toString());
        request.setAddress(locationCapture.getAddress());
        request.setCountryName(locationCapture.getCountryName());
        request.setLatitute(locationCapture.getLatitute());
        request.setLongitute(locationCapture.getLongitute());
        request.setLocality(locationCapture.getLocality());
        request.setLocationCaptured(locationCapture.getLocationCaptured());
        return request;
    }

    private LocationCapture getLocationCapture(Location lastLocation) {
        LocationCapture locationCapture = null;
        if (lastLocation != null) {
            LoggerUtils.d("Location = " + lastLocation);
            Address address = getAddress(AssinaturaActivity.this,
                    lastLocation.getLatitude(),
                    lastLocation.getLongitude());
            if (address != null) {
                LoggerUtils.d("Addres = " + address);
                locationCapture = new LocationCapture(address);
            }
        } else {
            boolean localizacaoEncontrada = false;
            locationCapture = new LocationCapture(localizacaoEncontrada);
        }
        return locationCapture;
    }

    public boolean checkPermission() {
        return checkPermissionLocation();
    }

    private void finalizarAtendimento() {

        // Verificação da internet
        if (!isNetworkConnected()) {
            noNetworkConnetedMessage();
            return;
        }



        if (checkPermission()) {
            FusedLocationProviderClient locationProviderClient = LocationServices.getFusedLocationProviderClient(AssinaturaActivity.this);
            locationProviderClient.getLastLocation()
                    .addOnSuccessListener(lastLocation -> {
                        CurrentChamadoAtendimento currentChamadoAtendimento = getCurrentChamadoAtendimento();
                        AtendimentoModel atendimentoModel = currentChamadoAtendimento.getAtendimentoModel();
                        CadastrarNovaTimelineNetworkingRequest request = cadastrarNovaTimelineNetworkingRequest(AndamentoAtendimentoEnum.CHAMADO_FINALIZADO,
                                "", "", atendimentoModel, lastLocation);

                        FinalizarAtendimentoRequestDTO finalizarAtendimentoRequestDTO =
                                new FinalizarAtendimentoRequestDTO(currentChamadoAtendimento, request);


                        compositeDisposable.add(mAtendimentoService.finalizarAtendimento(finalizarAtendimentoRequestDTO)
                                .observeOn(schedulerProvider.ui())
                                .subscribeOn(schedulerProvider.io())
                                .doOnSubscribe(d -> showLoading())
                                .subscribe(
                                        result -> {
                                            if (result.hasData()) {
                                                FinalizarAtendimentoResponseDTO data = result.getData();
                                                atualizarSincronizacaoRetorno(data, finalizarAtendimentoRequestDTO);
                                            } else {
                                                showDialogErroInterno();
                                            }
                                        },
                                        throwable ->  {
                                            LoggerUtils.error(throwable, this.getClass().getSimpleName());
                                            showDialogErroInterno();
                                        }, this::hideLoading
                                ));
                    }).addOnFailureListener(new OnFailureListener() {
                @Override
                public void onFailure(@NonNull Exception e) {
                    LoggerUtils.error(e, this.getClass().getSimpleName());
                    showDialogErroInterno();
                }
            });
        }


    }

    private void atualizarSincronizacaoRetorno(FinalizarAtendimentoResponseDTO data, FinalizarAtendimentoRequestDTO finalizarAtendimentoRequestDTO) {
        CurrentChamadoAtendimento currentChamadoAtendimento = getCurrentChamadoAtendimento();
        AtendimentoModel atendimentoModel = currentChamadoAtendimento.getAtendimentoModel();
        ChamadoModel chamadoModel = currentChamadoAtendimento.getChamadoModel();
        Atendimento atendimento = data.getAtendimento();

        // Atualizar chamado
        chamadoModel.setAtivoApp(data.getAtivoApp() != null && "1".equals(data.getAtivoApp()));
        Integer countAtendimentosRealizados = chamadoModel.getCountAtendimentosRealizados();
        chamadoModel.setCountAtendimentosRealizados(countAtendimentosRealizados + 1);
        StatusChamado statusFinalChamado = currentChamadoAtendimento.getStatusFinalChamado();
        chamadoModel.setStatusApp(statusFinalChamado == StatusChamado.PENDENTE ? chamadoModel.getNovoStatusAposReiniciar() : StatusChamado.CONCLUIDOS);
        mChamadoDAO.update(chamadoModel);

        // Timeline
        Timeline timeline = atendimento.getTimeline();
        TimelineModel timelineModel = TimelineModel.cadastrarNovaTimeline(timeline, finalizarAtendimentoRequestDTO.getTimeline(), atendimentoModel);
        long insert = mTimelineDAO.insert(timelineModel);
        TimelineModel byIdApp = mTimelineDAO.findByIdApp(insert);
        atendimentoModel.getTimelines().add(byIdApp);

        // Atualizar atendimento
        atendimentoModel.setAtivoApp(atendimento.getAtivoApp() != null && "1".equals(atendimento.getAtivoApp()));
        mAtendimentoDAO.update(atendimentoModel);

        clearCurrentChamadoAtendimento();

        Intent startIntent = openActivity(AssinaturaActivity.this, MainActivity3.class);
        startIntent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
        startActivity(startIntent);
        finish();
    }

    private void cadastrarNovaTimeline(ResponseTransfer<TimelineRequestResponse> result, CadastrarNovaTimelineNetworkingRequest request) {
        if (result.hasData()) {
            CurrentChamadoAtendimento currentChamadoAtendimento = getCurrentChamadoAtendimento();
            AtendimentoModel atendimentoModel = currentChamadoAtendimento.getAtendimentoModel();
            TimelineModel timelineModel = TimelineModel.cadastrarNovaTimeline(result.getData(), request, atendimentoModel);
            long insert = mTimelineDAO.insert(timelineModel);
            TimelineModel entity = mTimelineDAO.findByIdApp(insert);
            atendimentoModel.getTimelines().add(entity);
            // Altera o status do andamento atual
            atendimentoModel.setAndamentoChamadoApp(timelineModel.getAndamentoSnapshot());
            atualizarCurrentChamadoAtendimento(currentChamadoAtendimento);
            mAtendimentoDAO.update(atendimentoModel);
        } else {
            // TODO não implementado
        }
    }

    public boolean isStoragePermissionGranted() {
        if (getApplicationContext().checkSelfPermission(Manifest.permission.WRITE_EXTERNAL_STORAGE) == PackageManager.PERMISSION_GRANTED) {
            return true;
        } else {
            ActivityCompat.requestPermissions(this, new String[]{Manifest.permission.WRITE_EXTERNAL_STORAGE}, 1);
            return false;
        }
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (grantResults.length > 0 && grantResults[0] == PackageManager.PERMISSION_GRANTED) {

            view.setDrawingCacheEnabled(true);
            mSignature.save(view, StoredPath);
            //Toast.makeText(getApplicationContext(), "Successfully Saved", Toast.LENGTH_SHORT).show();
            // Calling the same class
            //recreate();
        } else {
            showDialogPermissaoStorage();
        }
    }

    @Override
    protected void onDestroy() {
        mPresenter.onDetach();
        compositeDisposable.dispose();
        super.onDestroy();
    }

    @Override
    public void openMainActivity() {
        if (mHasAssinature) {
            mSignature.save(view, StoredPath);
        } else {
            finalizarAtendimento();
        }


        //getCurrentChamadoAtendimento().getAtendimentoModel().

//        ChamadosStatic currentChamado = CurrentChamado.getInstance().getCurrentChamado();
//        if (currentChamado.getStatus().equals(StatusChamado.CONCLUIDOS)) {
//            Long idChamadoAtivo = CurrentChamado.getInstance().getIdChamadoAtivo();
//            ChamadosStatic.removerChamadoAtivo(idChamadoAtivo);
//        } else if(currentChamado.getStatus().equals(StatusChamado.ATIVO)) {
//            Long idChamadoAtivo = CurrentChamado.getInstance().getIdChamadoAtivo();
//            ChamadosStatic pesquisar = ChamadosStatic.pesquisar(idChamadoAtivo);
//            pesquisar.setStatus(pesquisar.getStatusAnterior());
//            pesquisar.salvar();
//            AtendimentoChamado currentAtendimentoChamado = CurrentChamado.getInstance().getCurrentAtendimentoChamado();
//            currentAtendimentoChamado.setDataFinalChamado(Calendar.getInstance().getTime());
//            pesquisar.updateAtendimento(currentAtendimentoChamado);
//        }
//        CurrentChamado.getInstance().removerChamadoAtivo();
//        CurrentChamado.getInstance().removerAtendimentoAtivo();
//
//
//        Intent startIntent = openActivity(AssinaturaActivity.this, MainActivity3.class);
//        startIntent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
//        startActivity(startIntent);
//        finish();
    }

    public class Signature extends View {

        private static final float STROKE_WIDTH = 5f;
        private static final float HALF_STROKE_WIDTH = STROKE_WIDTH / 2;
        private Paint paint = new Paint();
        private Path path = new Path();

        private float lastTouchX;
        private float lastTouchY;
        private final RectF dirtyRect = new RectF();

        public Signature(Context context, AttributeSet attrs) {
            super(context, attrs);
            paint.setAntiAlias(true);
            paint.setColor(Color.BLACK);
            paint.setStyle(Paint.Style.STROKE);
            paint.setStrokeJoin(Paint.Join.ROUND);
            paint.setStrokeWidth(STROKE_WIDTH);
        }

        public void save(View v, String StoredPath) {
            Timber.tag("log_tag").v("Width: %s", v.getWidth());
            Timber.tag("log_tag").v("Height: %s", v.getHeight());
            if (bitmap == null) {
                bitmap = Bitmap.createBitmap(mContent.getWidth(), mContent.getHeight(), Bitmap.Config.RGB_565);
            }
            Canvas canvas = new Canvas(bitmap);
            File image = null;
            try {
                // Output the file
//                FileOutputStream mFileOutStream = new FileOutputStream(image);
                v.draw(canvas);
//
//                // Convert the output file to Image such as .png
//                bitmap.compress(Bitmap.CompressFormat.JPEG, 100, mFileOutStream);
//                //Intent intent = new Intent(SignatureActivity.this, BillDetailsActivity.class);
////                intent.putExtra("imagePath", StoredPath);
////                startActivity(intent);
////                finish();
//                mFileOutStream.write(bitmap);
//                mFileOutStream.flush();
//                mFileOutStream.close();
                String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss", new Locale("pt", "BR")).format(new Date());
                String imageFileName = "jpg_" + timeStamp + "_";
                File storageDir = getExternalFilesDir(Environment.DIRECTORY_PICTURES);
                File f = File.createTempFile(
                        imageFileName,  /* prefix */
                        ".jpg",         /* suffix */
                        storageDir      /* directory */
                );

//Convert bitmap to byte array
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                bitmap.compress(Bitmap.CompressFormat.JPEG, 90 /*ignored for PNG*/, bos);
                byte[] bitmapdata = bos.toByteArray();

//write the bytes in file
                FileOutputStream fos = new FileOutputStream(f);
                fos.write(bitmapdata);
                fos.flush();
                fos.close();

                sincronizePhotoWithServer(f);
            } catch (Exception e) {
                Timber.tag("log_tag").v(e.toString());
            }

        }

        public void clear() {
            path.reset();
            invalidate();
            //mGetSign.setEnabled(false);
            mHasAssinature = false;
        }

        @Override
        protected void onDraw(Canvas canvas) {
            canvas.drawPath(path, paint);
        }

        @Override
        public boolean onTouchEvent(MotionEvent event) {
            float eventX = event.getX();
            float eventY = event.getY();
            //mGetSign.setEnabled(true);
            mHasAssinature = true;

            switch (event.getAction()) {
                case MotionEvent.ACTION_DOWN:
                    path.moveTo(eventX, eventY);
                    lastTouchX = eventX;
                    lastTouchY = eventY;
                    return true;

                case MotionEvent.ACTION_MOVE:

                case MotionEvent.ACTION_UP:

                    resetDirtyRect(eventX, eventY);
                    int historySize = event.getHistorySize();
                    for (int i = 0; i < historySize; i++) {
                        float historicalX = event.getHistoricalX(i);
                        float historicalY = event.getHistoricalY(i);
                        expandDirtyRect(historicalX, historicalY);
                        path.lineTo(historicalX, historicalY);
                    }
                    path.lineTo(eventX, eventY);
                    break;

                default:
                    debug("Ignored touch event: " + event.toString());
                    return false;
            }

            postInvalidate((int) (dirtyRect.left - HALF_STROKE_WIDTH),
                    (int) (dirtyRect.top - HALF_STROKE_WIDTH),
                    (int) (dirtyRect.right + HALF_STROKE_WIDTH),
                    (int) (dirtyRect.bottom + HALF_STROKE_WIDTH));

            lastTouchX = eventX;
            lastTouchY = eventY;

            return true;
        }

        private void debug(String string) {
            Timber.tag("log_tag").v(string);
        }

        private void expandDirtyRect(float historicalX, float historicalY) {
            if (historicalX < dirtyRect.left) {
                dirtyRect.left = historicalX;
            } else if (historicalX > dirtyRect.right) {
                dirtyRect.right = historicalX;
            }

            if (historicalY < dirtyRect.top) {
                dirtyRect.top = historicalY;
            } else if (historicalY > dirtyRect.bottom) {
                dirtyRect.bottom = historicalY;
            }
        }

        private void resetDirtyRect(float eventX, float eventY) {
            dirtyRect.left = Math.min(lastTouchX, eventX);
            dirtyRect.right = Math.max(lastTouchX, eventX);
            dirtyRect.top = Math.min(lastTouchY, eventY);
            dirtyRect.bottom = Math.max(lastTouchY, eventY);
        }
    }
}
