package br.com.softilux.softiluxapp.transfer.services

import br.com.softilux.core.webservice.ResponseListTransfer
import br.com.softilux.core.webservice.ResponseTransfer
import br.com.softilux.softiluxapp.transfer.datatransfer.ChamadoFilter
import br.com.softilux.softiluxapp.transfer.datatransfer.ChamadoResponse
import br.com.softilux.softiluxapp.transfer.datatransfer.statuschamado.VerificarStatusChamadoDTO
import io.reactivex.Observable
import io.reactivex.internal.operators.observable.ObservableOnErrorReturn
import retrofit2.Call
import retrofit2.http.Body
import retrofit2.http.GET
import retrofit2.http.POST
import retrofit2.http.Path

interface IChamadoService {

    @POST("api/v1/chamados")
    fun list(@Body chamadoFilter: ChamadoFilter) : Call<ResponseListTransfer<ChamadoResponse>>

    @POST("api/v1/chamados")
    fun loadAll(@Body chamadoFilter: ChamadoFilter) : Observable<ResponseListTransfer<ChamadoResponse>>

    @GET("api/v1/chamados/get/atendimentoativo/{seqOs}")
    fun getAtendimentoAtivoComTimelines(@Path("seqOs") numero: Long) : Observable<ResponseTransfer<ChamadoResponse>>

    @GET("api/v1/chamados/get/{id}/status")
    fun getStatusChamado(@Path("id") id: Long) : Observable<ResponseTransfer<VerificarStatusChamadoDTO>>

}
