package br.com.softilux.softiluxapp.transfer.services

import br.com.softilux.core.webservice.ResponseTransfer
import br.com.softilux.softiluxapp.transfer.datatransfer.NovoAtendimentoRequest
import br.com.softilux.softiluxapp.transfer.datatransfer.NovoAtendimentoResponse
import br.com.softilux.softiluxapp.transfer.datatransfer.finalizaratendimento.FinalizarAtendimentoRequestDTO
import br.com.softilux.softiluxapp.transfer.datatransfer.finalizaratendimento.FinalizarAtendimentoResponseDTO
import br.com.softilux.softiluxapp.transfer.datatransfer.reiniciaratendimento.AtendimentoReiniciadoDTORequest
import br.com.softilux.softiluxapp.transfer.datatransfer.reiniciaratendimento.AtendimentoReiniciadoDTOResponse
import br.com.softilux.softiluxapp.ui.chamado.solicitacoes.DadosIniciaisViagemDTO
import io.reactivex.Observable
import retrofit2.http.Body
import retrofit2.http.POST

interface IAtendimentoService {

    @POST("api/v1/atendimentos/save")
    fun saveNew(@Body request: NovoAtendimentoRequest): Observable<ResponseTransfer<NovoAtendimentoResponse>>

    @POST("api/v1/atendimentos/update/dadosiniciaisviagem")
    fun salvarDadosIniciaisViagem(@Body dadosIniciaisViagemDTO : DadosIniciaisViagemDTO) : Observable<ResponseTransfer<Boolean>>

    @POST("api/v1/atendimentos/reiniciaratendimento")
    fun reiniciarAtendimento(@Body atendimentoReiniciadoDTORequest: AtendimentoReiniciadoDTORequest)
            : Observable<ResponseTransfer<AtendimentoReiniciadoDTOResponse>>

    @POST("api/v1/atendimentos/finalizaratendimento")
    fun finalizarAtendimento(@Body finalizarAtendimentoRequestDTO : FinalizarAtendimentoRequestDTO)
            : Observable<ResponseTransfer<FinalizarAtendimentoResponseDTO>>


}
