package br.com.softilux.softiluxapp.transfer.datatransfer.reiniciaratendimento;

import com.blankj.utilcode.util.TimeUtils;
import com.google.gson.annotations.SerializedName;

import java.util.Date;
import java.util.concurrent.TimeUnit;

import br.com.softilux.core.utils.DateUtils;
import br.com.softilux.softiluxapp.data.db.model.AtendimentoModel;
import br.com.softilux.softiluxapp.transfer.datatransfer.CadastrarNovaTimelineNetworkingRequest;
import br.com.softilux.softiluxapp.ui.chamado.AndamentoAtendimentoEnum;

/**
 * Created by Vinicius on 22,Junho,2019
 */
public class AtendimentoReiniciadoDTORequest {

    /**
     * Id atendimento do portal
     * */
    @SerializedName("id")
    private Long idAtendimentoPortal;

    /**
     * Numero que relaciona o chamado com o atendimento
     * */
    @SerializedName("SEQOS")
    private Long seqOs;

    @SerializedName("DTVIAGEMFIN")
    private String dtViagemFin;

    @SerializedName("DTVIAGEMINI")
    private String dtViagemIni;

    @SerializedName("HRATENDIMENTOFIN")
    private String hrAtendimentoFin;

    /*
    * HH:mm no portal
    * */
    @SerializedName("HRVIAGEMFIN")
    private String hrViagemFin;

    /*
     * HH:mm no portal
     * */
    @SerializedName("HRVIAGEMINI")
    private String hrViagemIni;

    @SerializedName("TEMPOATENDIMENTO")
    private Long tempoAtendimento;

    @SerializedName("ativo_app")
    private Boolean ativoApp;

    @SerializedName("ANDAMENTO_CHAMADO_APP")
    private AndamentoAtendimentoEnum andamentoAtendimentoEnum;

    @SerializedName("timeline")
    private CadastrarNovaTimelineNetworkingRequest networkingRequest;

    public AtendimentoReiniciadoDTORequest() {}

    public AtendimentoReiniciadoDTORequest(AtendimentoModel atendimentoModel, CadastrarNovaTimelineNetworkingRequest request) {
        this.idAtendimentoPortal = atendimentoModel.getIdAtendimentoPortal();
        this.seqOs = atendimentoModel.getSeqOs();
        Date nowDate = TimeUtils.getNowDate();
        this.dtViagemFin = DateUtils.formatarDataEnvioJsonDtAtendimento(nowDate);
        this.dtViagemIni = DateUtils.formatarDataEnvioJsonDtAtendimento(atendimentoModel.getDtViagemInicial());
        this.hrAtendimentoFin = DateUtils.formatarHoraMinutoSegundoEnvioJson(nowDate);
        this.hrViagemFin = DateUtils.formatarHoraMinutoEnvioJson(nowDate);
        this.hrViagemIni = DateUtils.formatarHoraMinutoEnvioJson(atendimentoModel.getDtViagemInicial());
        // Muda o atendimento para inativo no portal
        this.ativoApp = false;
        this.networkingRequest = request;
        this.andamentoAtendimentoEnum = AndamentoAtendimentoEnum.CHAMADO_REINICIADO;
        this.tempoAtendimento = DateUtils.getDateDiff(atendimentoModel.getDtViagemInicial(), nowDate, TimeUnit.MINUTES);
    }

    public Long getIdAtendimentoPortal() {
        return idAtendimentoPortal;
    }

    public void setIdAtendimentoPortal(Long idAtendimentoPortal) {
        this.idAtendimentoPortal = idAtendimentoPortal;
    }

    public String getDtViagemFin() {
        return dtViagemFin;
    }

    public void setDtViagemFin(String dtViagemFin) {
        this.dtViagemFin = dtViagemFin;
    }

    public String getHrAtendimentoFin() {
        return hrAtendimentoFin;
    }

    public void setHrAtendimentoFin(String hrAtendimentoFin) {
        this.hrAtendimentoFin = hrAtendimentoFin;
    }

    public Long getTempoAtendimento() {
        return tempoAtendimento;
    }

    public void setTempoAtendimento(Long tempoAtendimento) {
        this.tempoAtendimento = tempoAtendimento;
    }

    public Boolean getAtivoApp() {
        return ativoApp;
    }

    public void setAtivoApp(Boolean ativoApp) {
        this.ativoApp = ativoApp;
    }

    public AndamentoAtendimentoEnum getAndamentoAtendimentoEnum() {
        return andamentoAtendimentoEnum;
    }

    public void setAndamentoAtendimentoEnum(AndamentoAtendimentoEnum andamentoAtendimentoEnum) {
        this.andamentoAtendimentoEnum = andamentoAtendimentoEnum;
    }

    public CadastrarNovaTimelineNetworkingRequest getNetworkingRequest() {
        return networkingRequest;
    }

    public void setNetworkingRequest(CadastrarNovaTimelineNetworkingRequest networkingRequest) {
        this.networkingRequest = networkingRequest;
    }

    public Long getSeqOs() {
        return seqOs;
    }

    public void setSeqOs(Long seqOs) {
        this.seqOs = seqOs;
    }

    public String getDtViagemIni() {
        return dtViagemIni;
    }

    public void setDtViagemIni(String dtViagemIni) {
        this.dtViagemIni = dtViagemIni;
    }

    public String getHrViagemFin() {
        return hrViagemFin;
    }

    public void setHrViagemFin(String hrViagemFin) {
        this.hrViagemFin = hrViagemFin;
    }

    public String getHrViagemIni() {
        return hrViagemIni;
    }

    public void setHrViagemIni(String hrViagemIni) {
        this.hrViagemIni = hrViagemIni;
    }
}
