package br.com.softilux.softiluxapp.transfer.datatransfer.finalizaratendimento;

import android.arch.persistence.room.ColumnInfo;

import com.google.gson.annotations.SerializedName;

import br.com.softilux.softiluxapp.data.db.model.ChamadoModel;
import br.com.softilux.softiluxapp.data.db.model.representation.ChamadoStatus;
import br.com.softilux.softiluxapp.data.db.model.representation.StatusChamado;

/**
 * Created by Vinicius on 26,Junho,2019
 */
public class FinalizarChamadoDTO {

    @SerializedName("id")
    private Long idChamado;

    @SerializedName("ativo_app")
    private Boolean ativoApp;

    @SerializedName("CDSTATUS")
    private String cdStatus;

    @SerializedName("STATUS")
    private ChamadoStatus statusPortal;

    @SerializedName("OBSDEFEITOATS")
    private String followUpTecnico;

    public FinalizarChamadoDTO(ChamadoModel chamadoModel, StatusChamado statusFinalizacao) {
        this.idChamado = chamadoModel.getIdChamadoWeb();
        this.ativoApp = false;
        this.cdStatus = chamadoModel.getCdStatus();
        this.statusPortal = statusFinalizacao == StatusChamado.PENDENTE ? ChamadoStatus.P : ChamadoStatus.O;
        this.followUpTecnico = chamadoModel.getFollowUpTecnico();
    }

    public Long getIdChamado() {
        return idChamado;
    }

    public void setIdChamado(Long idChamado) {
        this.idChamado = idChamado;
    }

    public Boolean getAtivoApp() {
        return ativoApp;
    }

    public void setAtivoApp(Boolean ativoApp) {
        this.ativoApp = ativoApp;
    }

    public String getCdStatus() {
        return cdStatus;
    }

    public void setCdStatus(String cdStatus) {
        this.cdStatus = cdStatus;
    }

    public ChamadoStatus getStatusPortal() {
        return statusPortal;
    }

    public void setStatusPortal(ChamadoStatus statusPortal) {
        this.statusPortal = statusPortal;
    }

    public String getFollowUpTecnico() {
        return followUpTecnico;
    }

    public void setFollowUpTecnico(String followUpTecnico) {
        this.followUpTecnico = followUpTecnico;
    }
}
