package br.com.softilux.softiluxapp.transfer.datatransfer.finalizaratendimento;

import com.google.gson.annotations.SerializedName;

import br.com.softilux.softiluxapp.data.db.model.CurrentChamadoAtendimento;
import br.com.softilux.softiluxapp.transfer.datatransfer.CadastrarNovaTimelineNetworkingRequest;

/**
 * Created by Vinicius on 25,Junho,2019
 */
public class FinalizarAtendimentoRequestDTO {

    @SerializedName("chamado")
    private FinalizarChamadoDTO finalizarChamadoDTO;

    @SerializedName("atendimento")
    private AtendimentoDTO atendimentoDTO;

    @SerializedName("timeline")
    private CadastrarNovaTimelineNetworkingRequest timeline;

    public FinalizarAtendimentoRequestDTO() {
    }

    public FinalizarAtendimentoRequestDTO(CurrentChamadoAtendimento currentChamadoAtendimento, CadastrarNovaTimelineNetworkingRequest timeline) {
        this.finalizarChamadoDTO = new FinalizarChamadoDTO(currentChamadoAtendimento.getChamadoModel(), currentChamadoAtendimento.getStatusFinalChamado());
        this.atendimentoDTO = new AtendimentoDTO(currentChamadoAtendimento.getAtendimentoModel());
        this.timeline = timeline;
    }

    public FinalizarChamadoDTO getFinalizarChamadoDTO() {
        return finalizarChamadoDTO;
    }

    public void setFinalizarChamadoDTO(FinalizarChamadoDTO finalizarChamadoDTO) {
        this.finalizarChamadoDTO = finalizarChamadoDTO;
    }

    public AtendimentoDTO getAtendimentoDTO() {
        return atendimentoDTO;
    }

    public void setAtendimentoDTO(AtendimentoDTO atendimentoDTO) {
        this.atendimentoDTO = atendimentoDTO;
    }

    public CadastrarNovaTimelineNetworkingRequest getTimeline() {
        return timeline;
    }

    public void setTimeline(CadastrarNovaTimelineNetworkingRequest timeline) {
        this.timeline = timeline;
    }
}
