package br.com.softilux.softiluxapp.transfer.datatransfer.finalizaratendimento;

import com.blankj.utilcode.util.TimeUtils;
import com.google.gson.annotations.SerializedName;

import java.util.Date;
import java.util.concurrent.TimeUnit;

import br.com.softilux.core.utils.DateUtils;
import br.com.softilux.softiluxapp.data.db.model.AtendimentoModel;
import br.com.softilux.softiluxapp.ui.chamado.AndamentoAtendimentoEnum;

/**
 * Created by Vinicius on 26,Junho,2019
 */
public class AtendimentoDTO {

    @SerializedName("id")
    private Long idAtendimentoPortal;

    @SerializedName("SEQOS")
    private Long seqOs;

    @SerializedName("empresa_id")
    private Long empresaId;

    @SerializedName("ID_BASE")
    private Long idBase;

    @SerializedName("ANDAMENTO_CHAMADO_APP")
    private AndamentoAtendimentoEnum andamentoAtendimentoEnum;

    @SerializedName("DTVIAGEMFIN")
    private String dtViagemFin;

    @SerializedName("DTVIAGEMINI")
    private String dtViagemIni;

    @SerializedName("HRATENDIMENTOFIN")
    private String hrAtendimentoFin;

    /*
     * HH:mm no portal
     * */
    @SerializedName("HRVIAGEMFIN")
    private String hrViagemFin;

    /*
     * HH:mm no portal
     * */
    @SerializedName("HRVIAGEMINI")
    private String hrViagemIni;

    @SerializedName("TEMPOATENDIMENTO")
    private Long tempoAtendimento;

    @SerializedName("ativo_app")
    private Boolean ativoApp;

    @SerializedName("VALKM")
    private String valkm;

    @SerializedName("VALATENDIMENTO")
    private String valatendimento;

    @SerializedName("ACAO")
    private String acao;

    @SerializedName("SINTOMA")
    private String sintoma;

    @SerializedName("CAUSA")
    private String causa;

    @SerializedName("ATUALIZADO")
    private Boolean atualizado;

    @SerializedName("VALOUTRASDESP")
    private String valoutrasdesp;

    @SerializedName("VALESTACIONAMENTO")
    private String valestacionamento;

    @SerializedName("VALPEDAGIO")
    private String valpedagio;

    @SerializedName("MEDIDORDESC")
    private Integer medidordesc;

    @SerializedName("MEDIDOR")
    private Integer medidor;

    @SerializedName("CDMEDIDOR")
    private String cdmedidor;

    @SerializedName("KMFINAL")
    private Integer kmfinal;

    @SerializedName("KMINICIAL")
    private Integer kminicial;

    @SerializedName("OBSERVACAO")
    private String observacao;

    @SerializedName("NOME_CONTATO")
    private String nomeContato;

    public AtendimentoDTO(AtendimentoModel atendimentoModel) {
        this.idAtendimentoPortal = atendimentoModel.getIdAtendimentoPortal();
        this.seqOs = atendimentoModel.getSeqOs();
        Date nowDate = TimeUtils.getNowDate();
        this.dtViagemFin = DateUtils.formatarDataEnvioJsonDtAtendimento(nowDate);
        this.dtViagemIni = DateUtils.formatarDataEnvioJsonDtAtendimento(atendimentoModel.getDtViagemInicial());
        this.hrAtendimentoFin = DateUtils.formatarHoraMinutoSegundoEnvioJson(nowDate);
        this.hrViagemFin = DateUtils.formatarHoraMinutoEnvioJson(nowDate);
        this.hrViagemIni = DateUtils.formatarHoraMinutoEnvioJson(atendimentoModel.getDtViagemInicial());
        // Muda o atendimento para inativo no portal
        this.ativoApp = false;
        // Muda para finalizado
        this.andamentoAtendimentoEnum = AndamentoAtendimentoEnum.CHAMADO_FINALIZADO;
        this.tempoAtendimento = DateUtils.getDateDiff(atendimentoModel.getDtViagemInicial(), nowDate, TimeUnit.MINUTES);

        this.atualizado = true;
        this.acao = atendimentoModel.getAcao();
        this.causa = atendimentoModel.getCausa();
        this.cdmedidor = atendimentoModel.getCdMedidor();
        this.kmfinal = atendimentoModel.getKmFinal();
        this.medidor = atendimentoModel.getMedidor();
        this.medidordesc = atendimentoModel.getMedidorDesc();
        this.observacao = atendimentoModel.getObservacao();
        this.valatendimento = atendimentoModel.getValorAtendimento() != null ? atendimentoModel.getValorAtendimento().toString(): "0";
        this.valestacionamento = atendimentoModel.getValorEstacionamento() != null ? atendimentoModel.getValorEstacionamento().toString(): "0";
        this.valoutrasdesp = atendimentoModel.getValorOutrasDespesas() != null ? atendimentoModel.getValorOutrasDespesas().toString(): "0";
        this.valpedagio = atendimentoModel.getValorPedagio() != null ? atendimentoModel.getValorPedagio().toString(): "0";
        this.nomeContato = atendimentoModel.getNomeContato();
    }

    public Long getIdAtendimentoPortal() {
        return idAtendimentoPortal;
    }

    public void setIdAtendimentoPortal(Long idAtendimentoPortal) {
        this.idAtendimentoPortal = idAtendimentoPortal;
    }

    public Long getSeqOs() {
        return seqOs;
    }

    public void setSeqOs(Long seqOs) {
        this.seqOs = seqOs;
    }

    public Long getEmpresaId() {
        return empresaId;
    }

    public void setEmpresaId(Long empresaId) {
        this.empresaId = empresaId;
    }

    public Long getIdBase() {
        return idBase;
    }

    public void setIdBase(Long idBase) {
        this.idBase = idBase;
    }

    public AndamentoAtendimentoEnum getAndamentoAtendimentoEnum() {
        return andamentoAtendimentoEnum;
    }

    public void setAndamentoAtendimentoEnum(AndamentoAtendimentoEnum andamentoAtendimentoEnum) {
        this.andamentoAtendimentoEnum = andamentoAtendimentoEnum;
    }

    public String getDtViagemFin() {
        return dtViagemFin;
    }

    public void setDtViagemFin(String dtViagemFin) {
        this.dtViagemFin = dtViagemFin;
    }

    public String getDtViagemIni() {
        return dtViagemIni;
    }

    public void setDtViagemIni(String dtViagemIni) {
        this.dtViagemIni = dtViagemIni;
    }

    public String getHrAtendimentoFin() {
        return hrAtendimentoFin;
    }

    public void setHrAtendimentoFin(String hrAtendimentoFin) {
        this.hrAtendimentoFin = hrAtendimentoFin;
    }

    public String getHrViagemFin() {
        return hrViagemFin;
    }

    public void setHrViagemFin(String hrViagemFin) {
        this.hrViagemFin = hrViagemFin;
    }

    public String getHrViagemIni() {
        return hrViagemIni;
    }

    public void setHrViagemIni(String hrViagemIni) {
        this.hrViagemIni = hrViagemIni;
    }

    public Long getTempoAtendimento() {
        return tempoAtendimento;
    }

    public void setTempoAtendimento(Long tempoAtendimento) {
        this.tempoAtendimento = tempoAtendimento;
    }

    public Boolean getAtivoApp() {
        return ativoApp;
    }

    public void setAtivoApp(Boolean ativoApp) {
        this.ativoApp = ativoApp;
    }

    public String getValkm() {
        return valkm;
    }

    public void setValkm(String valkm) {
        this.valkm = valkm;
    }

    public String getValatendimento() {
        return valatendimento;
    }

    public void setValatendimento(String valatendimento) {
        this.valatendimento = valatendimento;
    }

    public String getAcao() {
        return acao;
    }

    public void setAcao(String acao) {
        this.acao = acao;
    }

    public String getSintoma() {
        return sintoma;
    }

    public void setSintoma(String sintoma) {
        this.sintoma = sintoma;
    }

    public String getCausa() {
        return causa;
    }

    public void setCausa(String causa) {
        this.causa = causa;
    }

    public Boolean getAtualizado() {
        return atualizado;
    }

    public void setAtualizado(Boolean atualizado) {
        this.atualizado = atualizado;
    }

    public String getValoutrasdesp() {
        return valoutrasdesp;
    }

    public void setValoutrasdesp(String valoutrasdesp) {
        this.valoutrasdesp = valoutrasdesp;
    }

    public String getValestacionamento() {
        return valestacionamento;
    }

    public void setValestacionamento(String valestacionamento) {
        this.valestacionamento = valestacionamento;
    }

    public String getValpedagio() {
        return valpedagio;
    }

    public void setValpedagio(String valpedagio) {
        this.valpedagio = valpedagio;
    }

    public Integer getMedidordesc() {
        return medidordesc;
    }

    public void setMedidordesc(Integer medidordesc) {
        this.medidordesc = medidordesc;
    }

    public Integer getMedidor() {
        return medidor;
    }

    public void setMedidor(Integer medidor) {
        this.medidor = medidor;
    }

    public String getCdmedidor() {
        return cdmedidor;
    }

    public void setCdmedidor(String cdmedidor) {
        this.cdmedidor = cdmedidor;
    }

    public Integer getKmfinal() {
        return kmfinal;
    }

    public void setKmfinal(Integer kmfinal) {
        this.kmfinal = kmfinal;
    }

    public Integer getKminicial() {
        return kminicial;
    }

    public void setKminicial(Integer kminicial) {
        this.kminicial = kminicial;
    }

    public String getObservacao() {
        return observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    public String getNomeContato() {
        return nomeContato;
    }

    public void setNomeContato(String nomeContato) {
        this.nomeContato = nomeContato;
    }
}
