package br.com.softilux.softiluxapp.transfer.datatransfer;

import com.google.gson.annotations.SerializedName;

import org.apache.commons.lang3.math.NumberUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Calendar;
import java.util.Date;

import br.com.softilux.core.utils.DateUtils;
import br.com.softilux.softiluxapp.data.db.model.ChamadoModel;
import br.com.softilux.softiluxapp.data.db.model.representation.ChamadoStatus;
import br.com.softilux.softiluxapp.data.db.model.representation.Modalidade;
import br.com.softilux.softiluxapp.data.db.model.representation.StatusChamado;

/**
 * Created by Vinicius on 17,Abril,2019
 */
public class ChamadoResponse extends AbstractCrudResponse<ChamadoModel> {

    /**
     * id : 761848
     * SEQOSORIGEM : 761848
     * SEQOS : 278
     * empresa_id : 1
     * DTINCLUSAO : 2019-02-28
     * HRINCLUSAO : 14:53:00
     * CONTATO : LUCIANO
     * CDEMPRESA : 1
     * CDCLIENTE : 4
     * NMCLIENTE : REVENDA SP - TESTE DE NFE
     * CIDADE : SAO PAULO (SP)
     * ENDERECO : RUA DAS GARO
     * COMPLEMENTO : PISO SUPERIOR
     * BAIRRO : MOEMA
     * UF : SP
     * CEP : 40190900
     * DDD : 48
     * FONE : 4830281346
     * CELULAR :
     * EMAIL : luciano@softilux.com.br
     * CDEQUIPAMENTO : 12
     * STATUS : D
     * CDSTATUS : 0
     * NMSUPORTET : TECNICO1
     * TIPO_OS : 1
     * OBSDEFEITOCLI : abertura de chamado AMF
     * NMDEFEITO : ATOLAMENTO PAPEL
     * NMOSTP : ATENDIMENTO WEB
     * SERIE : 1233456
     * PATRIMONIO :
     * MODELO : 8080DN
     * DEPARTAMENTO : DIRETORIA
     * LOCALINSTAL :
     */

    @SerializedName("id")
    private Long idChamado;
    @SerializedName("SEQOSORIGEM")
    private Long seqOrigem;
    @SerializedName("SEQOS")
    private Long seqOS;
    @SerializedName("empresa_id")
    private Long empresaId;
    @SerializedName("DTINCLUSAO")
    private String dataInclusao;
    @SerializedName("HRINCLUSAO")
    private String horaInclusao;
    @SerializedName("DTPREVENTREGA")
    private String dataPrevisao;
    @SerializedName("HRPREVENTREGA")
    private String horaPrevisao;
    @SerializedName("CONTATO")
    private String contato;
    @SerializedName("CDEMPRESA")
    private Long cdEmpresa;
    @SerializedName("CDCLIENTE")
    private Long cdCliente;
    @SerializedName("NMCLIENTE")
    private String nmCliente;
    @SerializedName("CIDADE")
    private String cidade;
    @SerializedName("ENDERECO")
    private String endereco;
    @SerializedName("COMPLEMENTO")
    private String complemento;
    @SerializedName("BAIRRO")
    private String bairro;
    @SerializedName("UF")
    private String uf;
    @SerializedName("CEP")
    private String cep;
    @SerializedName("DDD")
    private String ddd;
    @SerializedName("FONE")
    private String fone;
    @SerializedName("CELULAR")
    private String celular;
    @SerializedName("EMAIL")
    private String email;
    @SerializedName("CDEQUIPAMENTO")
    private Long cdEquipamento;
    @SerializedName("STATUS")
    private ChamadoStatus status;
    @SerializedName("CDSTATUS")
    private String cdStatus;
    @SerializedName("NMSUPORTET")
    private String nmSuporte;
    @SerializedName("TIPO_OS")
    private Modalidade tiposOS;
    @SerializedName("OBSDEFEITOCLI")
    private String observacaoDefeitoCli;
    @SerializedName("NMDEFEITO")
    private String nmDefeito;
    @SerializedName("NMOSTP")
    private String nmOSTp;
    @SerializedName("SERIE")
    private String serieEquipamento;
    @SerializedName("PATRIMONIO")
    private String patrimonio;
    @SerializedName("MODELO")
    private String modelo;
    @SerializedName("DEPARTAMENTO")
    private String departamento;
    @SerializedName("LOCALINSTAL")
    private String localInstalacao;
    @SerializedName("ID_BASE")
    private Long idBase;
    @SerializedName("COUNT_ATENDIMENTOS_REALIZADOS")
    private Integer countAtendimentosRealizados;
    @SerializedName("ativo_app")
    private String ativoApp;

    public Long getIdChamado() {
        return idChamado;
    }

    public void setIdChamado(Long idChamado) {
        this.idChamado = idChamado;
    }

    public Long getSeqOrigem() {
        return seqOrigem;
    }

    public void setSeqOrigem(Long seqOrigem) {
        this.seqOrigem = seqOrigem;
    }

    public Long getSeqOS() {
        return seqOS;
    }

    public void setSeqOS(Long seqOS) {
        this.seqOS = seqOS;
    }

    public Long getEmpresaId() {
        return empresaId;
    }

    public void setEmpresaId(Long empresaId) {
        this.empresaId = empresaId;
    }

    public String getDataInclusao() {
        return dataInclusao;
    }

    public void setDataInclusao(String dataInclusao) {
        this.dataInclusao = dataInclusao;
    }

    public String getHoraInclusao() {
        return horaInclusao;
    }

    public void setHoraInclusao(String horaInclusao) {
        this.horaInclusao = horaInclusao;
    }

    public String getDataPrevisao() {
        return dataPrevisao;
    }

    public void setDataPrevisao(String dataPrevisao) {
        this.dataPrevisao = dataPrevisao;
    }

    public String getHoraPrevisao() {
        return horaPrevisao;
    }

    public void setHoraPrevisao(String horaPrevisao) {
        this.horaPrevisao = horaPrevisao;
    }

    public String getContato() {
        return contato;
    }

    public void setContato(String contato) {
        this.contato = contato;
    }

    public Long getCdEmpresa() {
        return cdEmpresa;
    }

    public void setCdEmpresa(Long cdEmpresa) {
        this.cdEmpresa = cdEmpresa;
    }

    public Long getCdCliente() {
        return cdCliente;
    }

    public void setCdCliente(Long cdCliente) {
        this.cdCliente = cdCliente;
    }

    public String getNmCliente() {
        return nmCliente;
    }

    public void setNmCliente(String nmCliente) {
        this.nmCliente = nmCliente;
    }

    public String getCidade() {
        return cidade;
    }

    public void setCidade(String cidade) {
        this.cidade = cidade;
    }

    public String getEndereco() {
        return endereco;
    }

    public void setEndereco(String endereco) {
        this.endereco = endereco;
    }

    public String getComplemento() {
        return complemento;
    }

    public void setComplemento(String complemento) {
        this.complemento = complemento;
    }

    public String getBairro() {
        return bairro;
    }

    public void setBairro(String bairro) {
        this.bairro = bairro;
    }

    public String getUf() {
        return uf;
    }

    public void setUf(String uf) {
        this.uf = uf;
    }

    public String getCep() {
        return cep;
    }

    public void setCep(String cep) {
        this.cep = cep;
    }

    public String getDdd() {
        return ddd;
    }

    public void setDdd(String ddd) {
        this.ddd = ddd;
    }

    public String getFone() {
        return fone;
    }

    public void setFone(String fone) {
        this.fone = fone;
    }

    public String getCelular() {
        return celular;
    }

    public void setCelular(String celular) {
        this.celular = celular;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Long getCdEquipamento() {
        return cdEquipamento;
    }

    public void setCdEquipamento(Long cdEquipamento) {
        this.cdEquipamento = cdEquipamento;
    }

    public ChamadoStatus getStatus() {
        return status;
    }

    public void setStatus(ChamadoStatus status) {
        this.status = status;
    }

    public String getCdStatus() {
        return cdStatus;
    }

    public void setCdStatus(String cdStatus) {
        this.cdStatus = cdStatus;
    }

    public String getNmSuporte() {
        return nmSuporte;
    }

    public void setNmSuporte(String nmSuporte) {
        this.nmSuporte = nmSuporte;
    }

    public Modalidade getTiposOS() {
        return tiposOS;
    }

    public void setTiposOS(Modalidade tiposOS) {
        this.tiposOS = tiposOS;
    }

    public String getObservacaoDefeitoCli() {
        return observacaoDefeitoCli;
    }

    public void setObservacaoDefeitoCli(String observacaoDefeitoCli) {
        this.observacaoDefeitoCli = observacaoDefeitoCli;
    }

    public String getNmDefeito() {
        return nmDefeito;
    }

    public void setNmDefeito(String nmDefeito) {
        this.nmDefeito = nmDefeito;
    }

    public String getNmOSTp() {
        return nmOSTp;
    }

    public void setNmOSTp(String nmOSTp) {
        this.nmOSTp = nmOSTp;
    }

    public String getSerieEquipamento() {
        return serieEquipamento;
    }

    public void setSerieEquipamento(String serieEquipamento) {
        this.serieEquipamento = serieEquipamento;
    }

    public String getPatrimonio() {
        return patrimonio;
    }

    public void setPatrimonio(String patrimonio) {
        this.patrimonio = patrimonio;
    }

    public String getModelo() {
        return modelo;
    }

    public void setModelo(String modelo) {
        this.modelo = modelo;
    }

    public String getDepartamento() {
        return departamento;
    }

    public void setDepartamento(String departamento) {
        this.departamento = departamento;
    }

    public String getLocalInstalacao() {
        return localInstalacao;
    }

    public void setLocalInstalacao(String localInstalacao) {
        this.localInstalacao = localInstalacao;
    }

    public Long getIdBase() {
        return idBase;
    }

    public void setIdBase(Long idBase) {
        this.idBase = idBase;
    }

    public Integer getCountAtendimentosRealizados() {
        return countAtendimentosRealizados;
    }

    public void setCountAtendimentosRealizados(Integer countAtendimentosRealizados) {
        this.countAtendimentosRealizados = countAtendimentosRealizados;
    }

    public String getAtivoApp() {
        return ativoApp;
    }

    public void setAtivoApp(String ativoApp) {
        this.ativoApp = ativoApp;
    }

    public boolean isChamadoAtendido() {
        return NumberUtils.INTEGER_ZERO < countAtendimentosRealizados;
    }

    @Override
    public ChamadoModel toModel() {
        ChamadoModel chamadoModel = new ChamadoModel();

        chamadoModel.setBairro(getBairro());
        chamadoModel.setCdCliente(getCdCliente());
        chamadoModel.setCdEmpresa(getCdEmpresa());
        chamadoModel.setCdEquipamento(getCdEquipamento());
        chamadoModel.setCdStatus(getCdStatus());
        chamadoModel.setCelular(getCelular());
        chamadoModel.setCep(getCep());
        chamadoModel.setUf(getUf());
        chamadoModel.setComplemento(getComplemento());
        chamadoModel.setDataInclusao(getDataInclusao());
        chamadoModel.setContato(getContato());
        chamadoModel.setDepartamento(getDepartamento());
        chamadoModel.setEmpresaId(getEmpresaId());
        chamadoModel.setDataPrevisao(getDataPrevisao());
        chamadoModel.setDdd(getDdd());
        chamadoModel.setEmail(getEmail());
        chamadoModel.setFone(getFone());
        chamadoModel.setHoraInclusao(getHoraInclusao());
        chamadoModel.setEndereco(getEndereco());
        chamadoModel.setIdChamadoWeb(getIdChamado());
        chamadoModel.setSeqOrigem(getSeqOrigem());
        chamadoModel.setSeqOS(getSeqOS());
        chamadoModel.setCidade(getCidade());
        chamadoModel.setLocalInstalacao(getLocalInstalacao());
        chamadoModel.setModelo(getModelo());
        chamadoModel.setNmCliente(getNmCliente());
        chamadoModel.setNmDefeito(getNmDefeito());
        chamadoModel.setNmOSTp(getNmOSTp());
        chamadoModel.setNmSuporte(getNmSuporte());
        chamadoModel.setSerieEquipamento(getSerieEquipamento());
        chamadoModel.setObservacaoDefeitoCli(getObservacaoDefeitoCli());
        chamadoModel.setHoraPrevisao(getHoraPrevisao());
        chamadoModel.setModalidadeOs(getTiposOS());
        chamadoModel.setPatrimonio(getPatrimonio());
        chamadoModel.setStatusPortal(getStatus());
        chamadoModel.setAtivoApp(getAtivoApp() != null && "1".equals(getAtivoApp()));
        chamadoModel.setStatusApp(converterStatus());
        chamadoModel.setCountAtendimentosRealizados(getCountAtendimentosRealizados());
        chamadoModel.setIdBase(getIdBase());


        return chamadoModel;
    }

    @NotNull
    private StatusChamado converterStatus() {
        StatusChamado statusChamadoApp;
        switch (this.status) {
            case A:
            case D:
            case E:
            case M:
            case P:
                statusChamadoApp = verificarStatusChamadoApp();
                break;
            default:
                statusChamadoApp = verificarStatusChamadoApp();
        }
        return statusChamadoApp;
    }

    @NotNull
    private StatusChamado verificarStatusChamadoApp() {
        if (getAtivoApp() != null && "1".equals(getAtivoApp())) return StatusChamado.ATIVO;

        return !isChamadoAtendido() && isChamadoAtrasado() ? StatusChamado.ATRASADOS : StatusChamado.LIBERADO_PARA_ATENDIMENTO;
    }

    @Nullable
    private Date getDataPrevisaoCompleta() {
        String data = dataPrevisao + " " + horaPrevisao;
        return DateUtils.parseData(data);
    }

    public String getDataPrevisaoCompletaAsString() {
        return dataPrevisao + " " + horaPrevisao;
    }

    private boolean isChamadoAtrasado() {
        Date dataPrevisao = getDataPrevisaoCompleta();
        Date instance = Calendar.getInstance().getTime();
        return dataPrevisao != null && instance.after(dataPrevisao);
    }
}