package br.com.softilux.softiluxapp.di.presentation;

import android.arch.lifecycle.ViewModel;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Map;

import javax.inject.Provider;

import br.com.softilux.softiluxapp.data.dao.ConfigDAO;
import br.com.softilux.softiluxapp.data.repository.AtendimentoRepository;
import br.com.softilux.softiluxapp.data.repository.ChamadoRepository;
import br.com.softilux.softiluxapp.data.repository.LoginRepository;
import br.com.softilux.softiluxapp.ui.login.LoginViewModel;
import br.com.softilux.softiluxapp.ui.main.ChamadoDetailsViewModel;
import br.com.softilux.softiluxapp.ui.main.ChamadoViewModel;
import br.com.softilux.softiluxapp.utils.rx.SchedulerProvider;
import dagger.MapKey;
import dagger.Module;
import dagger.Provides;
import dagger.multibindings.IntoMap;
import io.reactivex.disposables.CompositeDisposable;

@Module
public class ViewModelModule {

    @Target(ElementType.METHOD)
    @Retention(RetentionPolicy.RUNTIME)
    @MapKey
    @interface ViewModelKey {
        Class<? extends ViewModel> value();
    }

    @Provides
    ViewModelFactory viewModelFactory(Map<Class<? extends ViewModel>, Provider<ViewModel>> providerMap) {
        return new ViewModelFactory(providerMap);
    }

    @Provides
    @IntoMap
    @ViewModelKey(LoginViewModel.class)
    ViewModel bindLoginViewModel(LoginRepository loginRepository) {
        return new LoginViewModel(loginRepository);
    }

    @Provides
    @IntoMap
    @ViewModelKey(ChamadoViewModel.class)
    ViewModel bindChamadoViewModel(ChamadoRepository chamadoRepository) {
        return new ChamadoViewModel(chamadoRepository);
    }

    @Provides
    @IntoMap
    @ViewModelKey(ChamadoDetailsViewModel.class)
    ViewModel bindChamadoDetailsViewModel(ChamadoRepository chamadoRepository, AtendimentoRepository atendimentoRepository) {
        return new ChamadoDetailsViewModel(chamadoRepository, atendimentoRepository);
    }

}
