package br.com.softilux.softiluxapp.di.module;

import android.app.Application;

import com.androidnetworking.interceptors.HttpLoggingInterceptor;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.jakewharton.retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;

import java.util.concurrent.TimeUnit;

import javax.inject.Named;
import javax.inject.Singleton;

import br.com.softilux.softiluxapp.BuildConfig;
import br.com.softilux.softiluxapp.transfer.converter.NullOnEmptyConverterFactory;
import br.com.softilux.softiluxapp.transfer.services.IAtendimentoService;
import br.com.softilux.softiluxapp.transfer.services.IAuthWebService;
import br.com.softilux.softiluxapp.transfer.services.IChamadoService;
import br.com.softilux.softiluxapp.transfer.services.IFileService;
import br.com.softilux.softiluxapp.transfer.services.IMedidoresService;
import br.com.softilux.softiluxapp.transfer.services.ITimelineService;
import br.com.softilux.softiluxapp.transfer.services.ITipoStatusService;
import dagger.Module;
import dagger.Provides;
import okhttp3.OkHttpClient;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

@Module
public class NetworkingModule {

//    @Singleton
//    @Provides
//    OkHttpClient getOkHttpClient() {
//        HttpLoggingInterceptor httpLoggingInterceptor = new HttpLoggingInterceptor();
//        httpLoggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
//
//        return new OkHttpClient.Builder()
//                //.cache(cache)
//                .addInterceptor(httpLoggingInterceptor)
//                .readTimeout(20, TimeUnit.SECONDS)
//                .build();
//    }

//    @Singleton
//    @Provides
//    Gson providesGson() {
//        //Gson gson = new GsonBuilder().setDateFormat("dd-MM-yyyy HH:mm").create();
//        return new GsonBuilder()
//                .setDateFormat("yyyy-MM-dd HH:mm:ss")
//                .create();
//    }

    @Singleton
    @Named("pws")
    @Provides
    Retrofit provideRetrofitPws(@Named("pws") OkHttpClient httpClient, Gson gson) {
        return new Retrofit.Builder()
                .client(httpClient)
                .baseUrl(BuildConfig.PWS_URL)
                //.addConverterFactory(GsonConverterFactory.create(gson))
                .addConverterFactory(new NullOnEmptyConverterFactory())
                .addConverterFactory(GsonConverterFactory.create(gson))
                .addCallAdapterFactory(RxJava2CallAdapterFactory.create())
                .build();
    }

    @Singleton
    @Named("restserver")
    @Provides
    Retrofit provideRetrofitRest(@Named("restserver") OkHttpClient httpClient, Gson gson) {
        return new Retrofit.Builder()
                .client(httpClient)
                .baseUrl(BuildConfig.REST_SERVER)
                //.addConverterFactory(GsonConverterFactory.create(gson))
                .addConverterFactory(new NullOnEmptyConverterFactory())
                .addConverterFactory(GsonConverterFactory.create(gson))
                .addCallAdapterFactory(RxJava2CallAdapterFactory.create())
                .build();
    }

    @Singleton
    @Provides
    IAuthWebService providesAuthService(@Named("pws") Retrofit retrofit) {
        return retrofit.create(IAuthWebService.class);
    }

    @Singleton
    @Provides
    IChamadoService providesChamadoService(@Named("restserver") Retrofit retrofit) {
        return retrofit.create(IChamadoService.class);
    }

    @Singleton
    @Provides
    IAtendimentoService providesAtendimentoService(@Named("restserver") Retrofit retrofit) {
        return retrofit.create(IAtendimentoService.class);
    }

    @Singleton
    @Provides
    ITimelineService providesTimelineService(@Named("restserver") Retrofit retrofit) {
        return retrofit.create(ITimelineService.class);
    }

    @Singleton
    @Provides
    IFileService providesFileService(@Named("restserver") Retrofit retrofit) {
        return retrofit.create(IFileService.class);
    }

    @Singleton
    @Provides
    IMedidoresService provideMedidoresService(@Named("restserver") Retrofit retrofit) {
        return retrofit.create(IMedidoresService.class);
    }

    @Singleton
    @Provides
    ITipoStatusService provideTipoStatusService(@Named("restserver") Retrofit retrofit) {
        return retrofit.create(ITipoStatusService.class);
    }

}
