package br.com.softilux.softiluxapp.di.module;

import android.app.Application;

import com.androidnetworking.interceptors.HttpLoggingInterceptor;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;

import java.io.IOException;
import java.util.Date;
import java.util.concurrent.TimeUnit;

import javax.inject.Named;
import javax.inject.Singleton;

import br.com.softilux.softiluxapp.data.db.model.representation.ChamadoStatus;
import br.com.softilux.softiluxapp.data.db.model.representation.Modalidade;
import dagger.Module;
import dagger.Provides;
import okhttp3.Cache;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

@Module
public class HttpModule {

    @Singleton
    @Provides
    Cache providesCache(Application application) {
        int cacheSize = 10 * 1024 * 1024;// 10 MiB
        return new Cache(application.getCacheDir(), (long) cacheSize);
    }

    @Provides
    @Named("pws")
    @Singleton
    OkHttpClient getOkHttpClientPortal(Cache cache) {
        HttpLoggingInterceptor httpLoggingInterceptor = new HttpLoggingInterceptor();
        httpLoggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);

        return new OkHttpClient.Builder()
                .cache(cache)
                .addInterceptor(httpLoggingInterceptor)
                .readTimeout(20, TimeUnit.SECONDS)
                .build();
    }

    @Provides
    @Named("restserver")
    @Singleton
    OkHttpClient getOkHttpClient(Cache cache) {
        HttpLoggingInterceptor httpLoggingInterceptor = new HttpLoggingInterceptor();
        httpLoggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);

        return new OkHttpClient.Builder()
                .cache(cache)
                .addInterceptor(httpLoggingInterceptor)
                .addInterceptor(new Interceptor() {
                    @Override
                    public Response intercept(Chain chain) throws IOException {
                        Request originalRequest = chain.request();
                        Request.Builder builder = originalRequest.newBuilder()
                                .header("X-AUTH-TOKEN", "eyJ0eXAiOiJKV1QiLCJhbGciTWvLUzI1NiJ9IiRkYXRhIg");
                        Request newRequest = builder.build();
                        return chain.proceed(newRequest);
                    }
                })
                .readTimeout(20, TimeUnit.SECONDS)
                .build();
    }

    @Singleton
    @Provides
    Gson providesGson() {
        //Gson gson = new GsonBuilder().setDateFormat("dd-MM-yyyy HH:mm").create();
        return new GsonBuilder()
                .registerTypeAdapter(Date.class, new DateTypeDeserializer())
                .registerTypeAdapter(Date.class, new DateTypeSerializer())
                .registerTypeAdapter(Modalidade.class, new ModalidadeDeserializer())
                .registerTypeAdapter(ChamadoStatus.class, new ChamadoStatusDeserializer())
                .create();

//        return new GsonBuilder()
//                .setDateFormat("yyyy-MM-dd HH:mm:ss")
//                //.setDateFormat("HH:mm:ss")
//                .create();
    }

//    @Provides
//    @Singleton
//    Moshi provideMoshi() {
//        return new Moshi.Builder().build();
//    }


}
