package br.com.softilux.softiluxapp.di.module;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;

import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;

/**
 * Created by Vinicius on 18,Abril,2019
 */
public class DateTypeSerializer implements JsonSerializer<Date> {

    private static final String[] DATE_FORMATS = new String[]{
        "HH:mm:ss",
        "yyyy-MM-dd",
        "yyyy-MM-dd HH:mm:ss"
    };

    @Override
    public JsonElement serialize(Date src, Type typeOfSrc, JsonSerializationContext context) {
        for (String format : DATE_FORMATS) {
            String dateFormatAsString  = new SimpleDateFormat(format).format(src);
            return new JsonPrimitive(dateFormatAsString);
        }
        throw new JsonParseException("Unparseable date: \"" + src + "\". Supported formats: \n" + Arrays.toString(DATE_FORMATS));
    }
}
