package br.com.softilux.softiluxapp.di.module;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;

import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;

import br.com.softilux.core.utils.LoggerUtils;

/**
 * Created by Vinicius on 18,Abril,2019
 */
public class DateTypeDeserializer implements JsonDeserializer<Date> {

    private static final String[] DATE_FORMATS = new String[]{
            "yyyy-MM-dd'T'HH:mm:ssZ",
            "yyyy-MM-dd'T'HH:mm:ss",
            "yyyy-MM-dd",
            "EEE MMM dd HH:mm:ss z yyyy",
            "HH:mm:ss",
            "MM/dd/yyyy HH:mm:ss aaa",
            "yyyy-MM-dd'T'HH:mm:ss.SSSSSS",
            "yyyy-MM-dd'T'HH:mm:ss.SSSSSSS",
            "yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'",
            "MMM dd, yyyy HH:mm:ss",
            "MMMM dd, yyyy HH:mm:ss",
            "MMMM dd',' yyyy HH:mm:ss",
            "MMMM dd',' yyyy HH:mm:ss a",
            "MMMM dd, yyyy HH:mm:ss a",
            "MMM dd',' yyyy HH:mm:ss",
            "MMM dd',' yyyy HH:mm:ss a",
            "MMM d',' yyyy H:mm:ss a",
            "MMM dd, yyyy HH:mm:ss a"
    };

    @Override
    public Date deserialize(JsonElement jsonElement, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        for (String format : DATE_FORMATS) {
            try {
                return new SimpleDateFormat(format).parse(jsonElement.getAsString());
            } catch (ParseException e) {
                //continue
            }
            try {
                return new SimpleDateFormat(format, new Locale("pt", "BR")).parse(jsonElement.getAsString());
            } catch (ParseException e) {
                //continue
            }
            try {
                return new SimpleDateFormat(format, Locale.ENGLISH).parse(jsonElement.getAsString());
            } catch (ParseException e) {
                //continue
            }
        }
        LoggerUtils.error( "Erro ao converter data" + jsonElement);
        throw new JsonParseException("Unparseable date: \"" + jsonElement.getAsString() + "\". Supported formats: \n" + Arrays.toString(DATE_FORMATS));
    }
}
