package br.com.softilux.softiluxapp.di.module;

import android.app.Application;
import android.arch.persistence.room.Room;
import android.arch.persistence.room.RoomDatabase;

import javax.inject.Singleton;

import br.com.softilux.core.utils.constants.AppDatabaseConstants;
import br.com.softilux.softiluxapp.BuildConfig;
import br.com.softilux.softiluxapp.data.dao.AmazonPhotoDAO;
import br.com.softilux.softiluxapp.data.dao.AppDatabase;
import br.com.softilux.softiluxapp.data.dao.AtendimentoDAO;
import br.com.softilux.softiluxapp.data.dao.ChamadoDAO;
import br.com.softilux.softiluxapp.data.dao.ConfigDAO;
import br.com.softilux.softiluxapp.data.dao.TimelineDAO;
import dagger.Module;
import dagger.Provides;

@Module
public class DatabaseModule {

    private final Application mApplication;

    public DatabaseModule(Application application) {
        this.mApplication = application;
    }

    @Singleton
    @Provides
    AppDatabase provideDatabase() {
        RoomDatabase.Builder<AppDatabase> databaseBuilder = Room
                .databaseBuilder(mApplication, AppDatabase.class, AppDatabaseConstants.DB_NOME)
                .fallbackToDestructiveMigration();
//        if (BuildConfig.DEBUG)
            databaseBuilder.allowMainThreadQueries();

        return databaseBuilder.build();
    }

    @Singleton
    @Provides
    ConfigDAO provideConfigDAO(AppDatabase appDatabase) {
        return appDatabase.getConfigDAO();
    }

    @Singleton
    @Provides
    ChamadoDAO provideChamadoDAO(AppDatabase appDatabase) {
        return appDatabase.getChamadoDAO();
    }

    @Singleton
    @Provides
    AtendimentoDAO provideAtendimentoDAO(AppDatabase appDatabase) {
        return appDatabase.getAtendimentoDAO();
    }

    @Singleton
    @Provides
    TimelineDAO provideTimelineDAO(AppDatabase appDatabase) {
        return appDatabase.getTimelineDAO();
    }

    @Singleton
    @Provides
    AmazonPhotoDAO provideAmazonPhotoDAO(AppDatabase appDatabase) {
        return appDatabase.getAmazonPhotoDAO();
    }

}
