package br.com.softilux.softiluxapp.di.module;

import android.app.Application;
import android.content.Context;

import com.google.gson.Gson;

import javax.inject.Singleton;

import br.com.softilux.core.utils.constants.AppConstants;
import br.com.softilux.softiluxapp.BuildConfig;
import br.com.softilux.softiluxapp.R;
import br.com.softilux.softiluxapp.data.AppDataManager;
import br.com.softilux.softiluxapp.data.DataManager;
import br.com.softilux.softiluxapp.data.dao.ConfigDAO;
import br.com.softilux.softiluxapp.data.db.AppDbHelper;
import br.com.softilux.softiluxapp.data.db.DbHelper;
import br.com.softilux.softiluxapp.data.network.ApiHeader;
import br.com.softilux.softiluxapp.data.network.ApiHelper;
import br.com.softilux.softiluxapp.data.network.AppApiHelper;
import br.com.softilux.softiluxapp.data.nosql.IPaperBook;
import br.com.softilux.softiluxapp.data.preferences.PrivatePreferences;
import br.com.softilux.softiluxapp.data.prefs.AppPreferencesHelper;
import br.com.softilux.softiluxapp.data.prefs.PreferencesHelper;
import br.com.softilux.softiluxapp.data.repository.BaseRepository;
import br.com.softilux.softiluxapp.data.repository.ChamadoRepository;
import br.com.softilux.softiluxapp.data.repository.LoginRepository;
import br.com.softilux.softiluxapp.data.repository.UsuarioLogadoCache;
import br.com.softilux.softiluxapp.di.ApiInfo;
import br.com.softilux.softiluxapp.di.ApplicationContext;
import br.com.softilux.softiluxapp.di.DatabaseInfo;
import br.com.softilux.softiluxapp.di.PreferenceInfo;
import br.com.softilux.softiluxapp.transfer.services.IAuthWebService;
import br.com.softilux.softiluxapp.utils.rx.SchedulerProvider;
import dagger.Module;
import dagger.Provides;
import io.reactivex.disposables.CompositeDisposable;
import uk.co.chrisjenx.calligraphy.CalligraphyConfig;

@Module
public class ApplicationModule {

    private final Application mApplication;

    public ApplicationModule(Application application) {
        mApplication = application;
    }

    @Provides
    @ApplicationContext
    Context provideContext() {
        return mApplication;
    }

    @Provides
    Application provideApplication() {
        return mApplication;
    }

    @Provides
    @DatabaseInfo
    String provideDatabaseName() {
        return AppConstants.DB_NAME;
    }

    @Provides
    @ApiInfo
    String provideApiKey() {
        return BuildConfig.API_KEY;
    }

    @Provides
    @PreferenceInfo
    String providePreferenceName() {
        return AppConstants.PREF_NAME;
    }

    @Provides
    @Singleton
    DataManager provideDataManager(AppDataManager appDataManager) {
        return appDataManager;
    }

    @Provides
    @Singleton
    DbHelper provideDbHelper(AppDbHelper appDbHelper) {
        return appDbHelper;
    }

    @Provides
    @Singleton
    PreferencesHelper providePreferencesHelper(AppPreferencesHelper appPreferencesHelper) {
        return appPreferencesHelper;
    }

    @Provides
    @Singleton
    ApiHelper provideApiHelper(AppApiHelper appApiHelper) {
        return appApiHelper;
    }

    @Provides
    @Singleton
    ApiHeader.ProtectedApiHeader provideProtectedApiHeader(@ApiInfo String apiKey,
                                                           PreferencesHelper preferencesHelper) {
        return new ApiHeader.ProtectedApiHeader(
                apiKey,
                preferencesHelper.getCurrentUserId(),
                preferencesHelper.getAccessToken());
    }

    @Provides
    @Singleton
    CalligraphyConfig provideCalligraphyDefaultConfig() {
        return new CalligraphyConfig.Builder()
                .setDefaultFontPath("fonts/source-sans-pro/SourceSansPro-Regular.ttf")
                .setFontAttrId(R.attr.fontPath)
                .build();
    }

    @Provides
    BaseRepository provideIluxRepository(SchedulerProvider schedulerProvider, Gson gson,
                                         CompositeDisposable compositeDisposable,
                                         PrivatePreferences privatePreferences,
                                         IPaperBook iPaperBook) {
        return new BaseRepository(schedulerProvider, compositeDisposable, gson, privatePreferences, iPaperBook);
    }

//    @Provides
//    LoginRepository provideLoginRepository(IAuthWebService authService, ConfigDAO configDAO, BaseRepository masterRepository) {
//        return new LoginRepository(authService, configDAO, masterRepository);
//    }

    @Provides
    LoginRepository provideLoginRepository(LoginRepository loginRepository) {
        return loginRepository;
    }

    @Provides
    ChamadoRepository provideChamadoRepository(ChamadoRepository chamadoRepository) {
        return chamadoRepository;
    }

    @Provides
    UsuarioLogadoCache provideUsuarioLogadoCache(ConfigDAO configDAO, Gson gson) {
        return new UsuarioLogadoCache(configDAO, gson);
    }

}
