package br.com.softilux.softiluxapp.di.module;

import android.content.Context;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.LinearLayoutManager;

import java.util.ArrayList;

import javax.inject.Singleton;

import br.com.softilux.softiluxapp.data.dao.AppDatabase;
import br.com.softilux.softiluxapp.data.dao.ConfigDAO;
import br.com.softilux.softiluxapp.data.network.model.BlogResponse;
import br.com.softilux.softiluxapp.data.network.model.OpenSourceResponse;
import br.com.softilux.softiluxapp.di.ActivityContext;
import br.com.softilux.softiluxapp.di.PerActivity;
import br.com.softilux.softiluxapp.transfer.services.IAuthWebService;
import br.com.softilux.softiluxapp.ui.about.AboutMvpPresenter;
import br.com.softilux.softiluxapp.ui.about.AboutMvpView;
import br.com.softilux.softiluxapp.ui.about.AboutPresenter;
import br.com.softilux.softiluxapp.ui.assinatura.AssinaturaMvpPresenter;
import br.com.softilux.softiluxapp.ui.assinatura.AssinaturaMvpView;
import br.com.softilux.softiluxapp.ui.assinatura.AssinaturaPresenter;
import br.com.softilux.softiluxapp.ui.chamado.ChamadoManutencaoMvpPresenter;
import br.com.softilux.softiluxapp.ui.chamado.ChamadoManutencaoMvpView;
import br.com.softilux.softiluxapp.ui.chamado.ChamadoManutencaoPresenter;
import br.com.softilux.softiluxapp.ui.chamado.detalhes.DetalhesChamadoMvpPresenter;
import br.com.softilux.softiluxapp.ui.chamado.detalhes.DetalhesChamadoMvpView;
import br.com.softilux.softiluxapp.ui.chamado.detalhes.DetalhesChamadoPresenter;
import br.com.softilux.softiluxapp.ui.chamado.finalizar.FinalizarChamadoMvpPresenter;
import br.com.softilux.softiluxapp.ui.chamado.finalizar.FinalizarChamadoMvpView;
import br.com.softilux.softiluxapp.ui.chamado.finalizar.FinalizarChamadoPresenter;
import br.com.softilux.softiluxapp.ui.chamado.imagens.ImagensChamadoMvpPresenter;
import br.com.softilux.softiluxapp.ui.chamado.imagens.ImagensChamadoMvpView;
import br.com.softilux.softiluxapp.ui.chamado.imagens.ImagensChamadoPresenter;
import br.com.softilux.softiluxapp.ui.chamado.pausar.PausarChamadoDialogMvpPresenter;
import br.com.softilux.softiluxapp.ui.chamado.pausar.PausarChamadoDialogMvpView;
import br.com.softilux.softiluxapp.ui.chamado.pausar.PausarChamadoDialogPresenter;
import br.com.softilux.softiluxapp.ui.chamado.solicitacoes.SolicitacoesMvpPresenter;
import br.com.softilux.softiluxapp.ui.chamado.solicitacoes.SolicitacoesMvpView;
import br.com.softilux.softiluxapp.ui.chamado.solicitacoes.SolicitacoesPresenter;
import br.com.softilux.softiluxapp.ui.feed.FeedMvpPresenter;
import br.com.softilux.softiluxapp.ui.feed.FeedMvpView;
import br.com.softilux.softiluxapp.ui.feed.FeedPagerAdapter;
import br.com.softilux.softiluxapp.ui.feed.FeedPresenter;
import br.com.softilux.softiluxapp.ui.feed.blogs.BlogAdapter;
import br.com.softilux.softiluxapp.ui.feed.blogs.BlogMvpPresenter;
import br.com.softilux.softiluxapp.ui.feed.blogs.BlogMvpView;
import br.com.softilux.softiluxapp.ui.feed.blogs.BlogPresenter;
import br.com.softilux.softiluxapp.ui.feed.opensource.OpenSourceAdapter;
import br.com.softilux.softiluxapp.ui.feed.opensource.OpenSourceMvpPresenter;
import br.com.softilux.softiluxapp.ui.feed.opensource.OpenSourceMvpView;
import br.com.softilux.softiluxapp.ui.feed.opensource.OpenSourcePresenter;
import br.com.softilux.softiluxapp.ui.login.LoginMvpPresenter;
import br.com.softilux.softiluxapp.ui.login.LoginMvpView;
import br.com.softilux.softiluxapp.ui.login.LoginPresenter;
import br.com.softilux.softiluxapp.ui.main.ChamadoDetailPresenter;
import br.com.softilux.softiluxapp.ui.main.ChamadoDetailsMvpPresenter;
import br.com.softilux.softiluxapp.ui.main.ChamadoDetailsMvpView;
import br.com.softilux.softiluxapp.ui.main.MainMvpPresenter;
import br.com.softilux.softiluxapp.ui.main.MainMvpView;
import br.com.softilux.softiluxapp.ui.main.MainPresenter;
import br.com.softilux.softiluxapp.ui.main.rating.RatingDialogMvpPresenter;
import br.com.softilux.softiluxapp.ui.main.rating.RatingDialogMvpView;
import br.com.softilux.softiluxapp.ui.main.rating.RatingDialogPresenter;
import br.com.softilux.softiluxapp.ui.permissao.PermissaoMvpPresenter;
import br.com.softilux.softiluxapp.ui.permissao.PermissaoMvpView;
import br.com.softilux.softiluxapp.ui.permissao.PermissaoPresenter;
import br.com.softilux.softiluxapp.ui.solicitacoes.NovaSolicitacaoMvpPresenter;
import br.com.softilux.softiluxapp.ui.solicitacoes.NovaSolicitacaoMvpView;
import br.com.softilux.softiluxapp.ui.solicitacoes.NovaSolicitacaoPresenter;
import br.com.softilux.softiluxapp.ui.splash.SplashMvpPresenter;
import br.com.softilux.softiluxapp.ui.splash.SplashMvpView;
import br.com.softilux.softiluxapp.ui.splash.SplashPresenter;
import br.com.softilux.softiluxapp.utils.rx.AppSchedulerProvider;
import br.com.softilux.softiluxapp.utils.rx.SchedulerProvider;
import dagger.Module;
import dagger.Provides;
import io.reactivex.disposables.CompositeDisposable;

@Module
public class ActivityModule {

    private AppCompatActivity mActivity;

    public ActivityModule(AppCompatActivity activity) {
        this.mActivity = activity;
    }

    @Provides
    @ActivityContext
    Context provideContext() {
        return mActivity;
    }

    @Provides
    AppCompatActivity provideActivity() {
        return mActivity;
    }

    @Provides
    CompositeDisposable provideCompositeDisposable() {
        return new CompositeDisposable();
    }

    @Provides
    SchedulerProvider provideSchedulerProvider() {
        return new AppSchedulerProvider();
    }

    @Provides
    @PerActivity
    SplashMvpPresenter<SplashMvpView> provideSplashPresenter(SplashPresenter<SplashMvpView> presenter) {
        return presenter;
    }

    @Provides
    AboutMvpPresenter<AboutMvpView> provideAboutPresenter( AboutPresenter<AboutMvpView> presenter) {
        return presenter;
    }

    @Provides
    @PerActivity
    LoginMvpPresenter<LoginMvpView> provideLoginPresenter(LoginPresenter<LoginMvpView> presenter) {
        return presenter;
    }

    @Provides
    @PerActivity
    MainMvpPresenter<MainMvpView> provideMainPresenter(MainPresenter<MainMvpView> presenter) {
        return presenter;
    }

    @Provides
    @PerActivity
    ChamadoDetailsMvpPresenter<ChamadoDetailsMvpView> provideChamadoDetailsMvpPresenter(ChamadoDetailPresenter<ChamadoDetailsMvpView> presenter) {
        return presenter;
    }

    @Provides
    @PerActivity
    ChamadoManutencaoMvpPresenter<ChamadoManutencaoMvpView> provideChamadoManutencaoMvpPresenter(
            ChamadoManutencaoPresenter<ChamadoManutencaoMvpView> presenter) {
        return presenter;
    }

    @Provides
    @PerActivity
    NovaSolicitacaoMvpPresenter<NovaSolicitacaoMvpView> provideNovaSolicitacaoMvpPresenter(
            NovaSolicitacaoPresenter<NovaSolicitacaoMvpView> presenter) {
        return presenter;
    }

    @Provides
    @PerActivity
    SolicitacoesMvpPresenter<SolicitacoesMvpView> provideSolicitacoesMvpPresenter(
            SolicitacoesPresenter<SolicitacoesMvpView> presenter) {
        return presenter;
    }

    @Provides
    @PerActivity
    ImagensChamadoMvpPresenter<ImagensChamadoMvpView> provideImagensChamadoMvpPresenter(
            ImagensChamadoPresenter<ImagensChamadoMvpView> presenter) {
        return presenter;
    }

    @Provides
    @PerActivity
    PermissaoMvpPresenter<PermissaoMvpView> providePermissaoMvpPresenter(
            PermissaoPresenter<PermissaoMvpView> presenter) {
        return presenter;
    }

    @Provides
    @PerActivity
    FinalizarChamadoMvpPresenter<FinalizarChamadoMvpView> provideFinalizarChamadoMvpPresenter(
            FinalizarChamadoPresenter<FinalizarChamadoMvpView> presenter) {
        return presenter;
    }

    @Provides
    @PerActivity
    DetalhesChamadoMvpPresenter<DetalhesChamadoMvpView> provideDetalhesChamadoPresenter(
            DetalhesChamadoPresenter<DetalhesChamadoMvpView> presenter) {
        return presenter;
    }

    @Provides
    @PerActivity
    AssinaturaMvpPresenter<AssinaturaMvpView> provideAssinaturaPresenter(AssinaturaPresenter<AssinaturaMvpView> presenter) {
        return presenter;
    }

    @Provides
    RatingDialogMvpPresenter<RatingDialogMvpView> provideRateUsPresenter(
            RatingDialogPresenter<RatingDialogMvpView> presenter) {
        return presenter;
    }

    @Provides
    PausarChamadoDialogMvpPresenter<PausarChamadoDialogMvpView> provideChamadoDialogMvpPresenter(
            PausarChamadoDialogPresenter<PausarChamadoDialogMvpView> presenter) {
        return presenter;
    }

    @Provides
    FeedMvpPresenter<FeedMvpView> provideFeedPresenter(
            FeedPresenter<FeedMvpView> presenter) {
        return presenter;
    }

    @Provides
    OpenSourceMvpPresenter<OpenSourceMvpView> provideOpenSourcePresenter(
            OpenSourcePresenter<OpenSourceMvpView> presenter) {
        return presenter;
    }

    @Provides
    BlogMvpPresenter<BlogMvpView> provideBlogMvpPresenter(
            BlogPresenter<BlogMvpView> presenter) {
        return presenter;
    }

    @Provides
    FeedPagerAdapter provideFeedPagerAdapter(AppCompatActivity activity) {
        return new FeedPagerAdapter(activity.getSupportFragmentManager());
    }

    @Provides
    OpenSourceAdapter provideOpenSourceAdapter() {
        return new OpenSourceAdapter(new ArrayList<OpenSourceResponse.Repo>());
    }

    @Provides
    BlogAdapter provideBlogAdapter() {
        return new BlogAdapter(new ArrayList<BlogResponse.Blog>());
    }

    @Provides
    LinearLayoutManager provideLinearLayoutManager(AppCompatActivity activity) {
        return new LinearLayoutManager(activity);
    }

}
