package br.com.softilux.softiluxapp.di.component2;

import android.app.Service;
import android.content.Context;

import br.com.softilux.softiluxapp.utils.rx.AppSchedulerProvider;
import br.com.softilux.softiluxapp.utils.rx.SchedulerProvider;
import dagger.Module;
import dagger.Provides;
import io.reactivex.disposables.CompositeDisposable;

@Module
public class ServiceModule {

    private final Service mService;

    public ServiceModule(Service service) {
        mService = service;
    }

    @Provides
    Service service() {
        return mService;
    }

    @Provides
    Context context(Service service) {
        return service;
    }

    @Provides
    CompositeDisposable provideCompositeDisposable() {
        return new CompositeDisposable();
    }

    @Provides
    SchedulerProvider provideSchedulerProvider() {
        return new AppSchedulerProvider();
    }

}
