package br.com.softilux.softiluxapp.di.component2;

import android.app.Application;
import android.content.Context;

import javax.inject.Singleton;

import br.com.softilux.softiluxapp.SoftiluxApp;
import br.com.softilux.softiluxapp.data.DataManager;
import br.com.softilux.softiluxapp.di.ApplicationContext;
import br.com.softilux.softiluxapp.di.module.DatabaseModule;
import br.com.softilux.softiluxapp.di.module.HttpModule;
import br.com.softilux.softiluxapp.di.module.NetworkingModule;
import br.com.softilux.softiluxapp.di.presentation.PresentationComponent;
import br.com.softilux.softiluxapp.di.presentation.PresentationModule;
import dagger.Component;

@Singleton
@Component(modules = {ApplicationModule.class,
        NetworkingModule.class,
        HttpModule.class,
        DatabaseModule.class})
public interface ApplicationComponent {
    void inject(SoftiluxApp application);

    PresentationComponent newPresentationComponent(PresentationModule presentationModule);

    ServiceComponent newServiceComponent(ServiceModule serviceModule);

    @ApplicationContext
    Context context();

    Application application();

    DataManager getDataManager();
}
