package br.com.softilux.softiluxapp.di.component;

import android.app.Application;
import android.content.Context;

import javax.inject.Singleton;

import br.com.softilux.softiluxapp.SoftiluxApp;
import br.com.softilux.softiluxapp.data.DataManager;
import br.com.softilux.softiluxapp.di.ApplicationContext;
import br.com.softilux.softiluxapp.di.module.ApplicationModule;
import br.com.softilux.softiluxapp.di.module.DatabaseModule;
import br.com.softilux.softiluxapp.di.module.NetworkingModule;
import br.com.softilux.softiluxapp.service.SyncService;
import dagger.Component;

@Singleton
@Component(modules = {ApplicationModule.class,
        DatabaseModule.class,
        NetworkingModule.class})
public interface ApplicationComponent {

    void inject(SoftiluxApp app);

    void inject(SyncService service);

    @ApplicationContext
    Context context();

    Application application();

    DataManager getDataManager();
}