package br.com.softilux.softiluxapp.data.repository;

import com.google.gson.Gson;

import java.util.concurrent.Callable;

import javax.inject.Inject;

import br.com.softilux.core.entities.Config;
import br.com.softilux.softiluxapp.data.dao.ConfigDAO;
import br.com.softilux.softiluxapp.transfer.datatransfer.UserResponse;
import io.reactivex.Observable;

/**
 * Created by Vinicius on 23,Abril,2019
 */
public class UsuarioLogadoCache {

    public static UserResponse usuarioLogado = null;
    public static Observable<UserResponse> usuarioLogadoObserver = null;
    private final ConfigDAO configDAO;
    private final Gson gson;

    @Inject
    public UsuarioLogadoCache(ConfigDAO configDAO, Gson gson) {
        this.configDAO = configDAO;
        this.gson = gson;
    }

    public UserResponse getLoggedUser() {
        if (usuarioLogado != null)
            return usuarioLogado;
        loadUserObservable();
        return usuarioLogado;
    }

    public Observable<UserResponse> getLoggedUserObserver() {
        if (usuarioLogadoObserver != null)
            return usuarioLogadoObserver;
        usuarioLogadoObserver = loadUserObservable();
        return usuarioLogadoObserver;
    }

    private Observable<UserResponse> loadUserObservable() {
        return Observable.fromCallable(new Callable<UserResponse>() {
            @Override
            public UserResponse call() throws Exception {
                UserResponse user = null;
                Config auth = configDAO.findByChave("Auth");
                if (auth != null)
                    user = gson.fromJson(auth.getValor(), UserResponse.class);
                return user;
            }
        });
    }

}
