package br.com.softilux.softiluxapp.data.repository;

import com.google.gson.Gson;

import java.util.concurrent.Callable;

import javax.inject.Inject;

import br.com.softilux.core.entities.Config;
import br.com.softilux.core.utils.LoggerUtils;
import br.com.softilux.core.webservice.ResponseTransfer;
import br.com.softilux.softiluxapp.data.DataManager;
import br.com.softilux.softiluxapp.data.dao.ConfigDAO;
import br.com.softilux.softiluxapp.data.db.model.UsuarioLogado;
import br.com.softilux.softiluxapp.data.nosql.IPaperBook;
import br.com.softilux.softiluxapp.data.preferences.Preferences;
import br.com.softilux.softiluxapp.transfer.datatransfer.UserResponse;
import br.com.softilux.softiluxapp.transfer.services.IAuthWebService;
import br.com.softilux.softiluxapp.utils.rx.SchedulerProvider;
import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.Observable;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Action;

/**
 * Created by Vinicius on 09,Abril,2019
 */

public class LoginRepository extends BaseRepository {

    private final String TAG = getClass().getSimpleName();

    private final IAuthWebService authService;

    private final ConfigDAO configDAO;

    @Inject
    public LoginRepository(IAuthWebService authService,
                           ConfigDAO configDAO,
                           SchedulerProvider schedulerProvider,
                           CompositeDisposable compositeDisposable,
                           Gson gson, Preferences preferences, IPaperBook iPaperBook) {
        super(schedulerProvider, compositeDisposable, gson, preferences, iPaperBook);
        this.authService = authService;
        this.configDAO = configDAO;
    }

    public IAuthWebService getAuthService() {
        return authService;
    }

    public ConfigDAO getConfigDAO() {
        return configDAO;
    }

    public void salvarUsuario(ResponseTransfer<UserResponse> response) {
        UserResponse user = response.getData();
        UsuarioLogado usuarioLogado = new UsuarioLogado(user);
        // Salvar usuario logado
        this.savePreferences(usuarioLogado);
        // Paper save
        this.getPaperBook().salvarUsuarioLogado(usuarioLogado);
        this.getPaperBook().setLogginMode(DataManager.LoggedInMode.LOGGED_IN_MODE_SERVER);
        //this.save(user);
    }

    private void savePreferences(UsuarioLogado user) {
        Preferences privatePreferences = getPreferences();
        privatePreferences.setCurrentUserLoggedInMode(DataManager.LoggedInMode.LOGGED_IN_MODE_SERVER);
        privatePreferences.setUsuarioLogado(user);
    }

    private void save(UserResponse user) {
//        Observable<Boolean> booleanObservable = Observable.fromCallable(new Callable<Boolean>() {
//            @Override
//            public Boolean call() throws Exception {
//                Config config = new Config("Auth", getGson().toJson(user));
//                getConfigDAO().insert(config);
//                return true;
//            }
//        });

        Completable.fromAction(new Action() {
            @Override
            public void run() throws Exception {
                Config config = new Config("Auth", getGson().toJson(user));
                getConfigDAO().insert(config);
            }
        }).subscribeOn(getSchedulerProvider().io())
                .observeOn(getSchedulerProvider().ui())
                .subscribe(new CompletableObserver() {
                    @Override
                    public void onSubscribe(Disposable d) {

                    }

                    @Override
                    public void onComplete() {

                    }

                    @Override
                    public void onError(Throwable e) {
                        LoggerUtils.error(e, TAG + " (save)");
                    }

                });
    }

}
