package br.com.softilux.softiluxapp.data.repository;

import com.google.gson.Gson;

import javax.inject.Inject;

import br.com.softilux.softiluxapp.data.db.model.UsuarioLogado;
import br.com.softilux.softiluxapp.data.nosql.IPaperBook;
import br.com.softilux.softiluxapp.data.nosql.PaperBook;
import br.com.softilux.softiluxapp.data.preferences.Preferences;
import br.com.softilux.softiluxapp.utils.rx.SchedulerProvider;
import io.reactivex.disposables.CompositeDisposable;

/**
 * Created by Vinicius on 23,Abril,2019
 */
public class BaseRepository {

    private final SchedulerProvider schedulerProvider;

    private final CompositeDisposable compositeDisposable;

    private final Gson gson;

    private final Preferences preferences;

    private final IPaperBook mPaperBook;

    @Inject
    public BaseRepository(SchedulerProvider schedulerProvider,
                          CompositeDisposable compositeDisposable,
                          Gson gson,
                          Preferences preferences,
                          IPaperBook iPaperBook) {
        this.schedulerProvider = schedulerProvider;
        this.compositeDisposable = compositeDisposable;
        this.gson = gson;
        this.preferences = preferences;
        this.mPaperBook = iPaperBook;
    }

    public SchedulerProvider getSchedulerProvider() {
        return schedulerProvider;
    }

    public CompositeDisposable getCompositeDisposable() {
        return compositeDisposable;
    }

    public Gson getGson() {
        return gson;
    }

    public Preferences getPreferences() {
        return preferences;
    }

    public IPaperBook getPaperBook() {
        return mPaperBook;
    }

    /**
     * {@link #getUsuarioLogado}
     * */
    @Deprecated
    public UsuarioLogado getCurrentUser() {
        return getPreferences().getUsuarioLogado();
    }

    public UsuarioLogado getUsuarioLogado() {
        return getPaperBook().getUsuarioLogado();
    }

}
