package br.com.softilux.softiluxapp.data.repository;

import com.google.gson.Gson;

import org.apache.commons.collections4.CollectionUtils;

import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;

import javax.inject.Inject;

import br.com.softilux.core.utils.DateUtils;
import br.com.softilux.core.webservice.ResponseListTransfer;
import br.com.softilux.core.webservice.ResponseTransfer;
import br.com.softilux.softiluxapp.data.DataManager;
import br.com.softilux.softiluxapp.data.dao.AppDatabase;
import br.com.softilux.softiluxapp.data.dao.AtendimentoDAO;
import br.com.softilux.softiluxapp.data.dao.ChamadoDAO;
import br.com.softilux.softiluxapp.data.dao.TimelineDAO;
import br.com.softilux.softiluxapp.data.db.model.AtendimentoModel;
import br.com.softilux.softiluxapp.data.db.model.ChamadoModel;
import br.com.softilux.softiluxapp.data.db.model.CurrentChamadoAtendimento;
import br.com.softilux.softiluxapp.data.db.model.TimelineModel;
import br.com.softilux.softiluxapp.data.db.model.representation.StatusChamado;
import br.com.softilux.softiluxapp.data.nosql.IPaperBook;
import br.com.softilux.softiluxapp.data.preferences.Preferences;
import br.com.softilux.softiluxapp.data.repository.interfaces.IAtendimentoRepository;
import br.com.softilux.softiluxapp.transfer.datatransfer.NovoAtendimentoRequest;
import br.com.softilux.softiluxapp.transfer.datatransfer.ChamadoFilter;
import br.com.softilux.softiluxapp.transfer.datatransfer.ChamadoResponse;
import br.com.softilux.softiluxapp.transfer.datatransfer.NovoAtendimentoResponse;
import br.com.softilux.softiluxapp.transfer.datatransfer.ReponseNovoAtendimentoDTO;
import br.com.softilux.softiluxapp.transfer.datatransfer.TimelineNovoAtendimentoDTO;
import br.com.softilux.softiluxapp.transfer.services.IAtendimentoService;
import br.com.softilux.softiluxapp.utils.rx.SchedulerProvider;
import io.reactivex.Observable;
import io.reactivex.disposables.CompositeDisposable;

/**
 * Created by Vinicius on 30,Abril,2019
 */
public class AtendimentoRepository extends BaseRepository implements IAtendimentoRepository {

    private final IAtendimentoService mAtendimentoService;

    private final AtendimentoDAO mAtendimentoDAO;

    private final TimelineDAO mTimelineDAO;

    private final ChamadoDAO mChamadoDAO;

    private final AppDatabase appDatabase;

    @Inject
    public AtendimentoRepository(SchedulerProvider schedulerProvider,
                                 CompositeDisposable compositeDisposable,
                                 Gson gson, Preferences preferences, IPaperBook iPaperBook,
                                 IAtendimentoService iAtendimentoService,
                                 AtendimentoDAO atendimentoDAO,
                                 TimelineDAO timelineDAO, ChamadoDAO chamadoDAO, AppDatabase appDatabase) {
        super(schedulerProvider, compositeDisposable, gson, preferences, iPaperBook);
        this.mAtendimentoService = iAtendimentoService;
        this.mAtendimentoDAO = atendimentoDAO;
        this.mTimelineDAO = timelineDAO;
        this.mChamadoDAO = chamadoDAO;
        this.appDatabase = appDatabase;
    }

    @Override
    public Observable<AtendimentoModel> observableFindOneDatabase(Long id) {
        return null;
    }

    @Override
    public Observable<Boolean> observableDeleteAllDatabase() {
        return null;
    }

    @Override
    public Observable<Boolean> observableSaveAllDatabase(List<AtendimentoModel> models) {
        return null;
    }

    @Override
    public Observable<ResponseListTransfer<ChamadoResponse>> loadAllNetworking(ChamadoFilter filter) {
        return null;
    }

    public Observable<AtendimentoModel> saveNew(AtendimentoModel atendimentoModel) {
        return Observable.fromCallable(new Callable<AtendimentoModel>() {
            @Override
            public AtendimentoModel call() throws Exception {
                Long inserted = mAtendimentoDAO.insert(atendimentoModel);

                if (CollectionUtils.isNotEmpty(atendimentoModel.getTimelines())) {
                    atendimentoModel
                            .getTimelines()
                            .forEach(t -> t.setIdAtendimentoApp(inserted));
                    mTimelineDAO.insertAll(atendimentoModel.getTimelines());
                }

                //=============================Carregar atendimento apos salvar
                AtendimentoModel savedEntity = mAtendimentoDAO.findByIdApp(inserted);

                savedEntity.setTimelines(mTimelineDAO.findAllByIdApp(savedEntity.getIdApp()));

                return savedEntity;
            }
        });
    }

    public Observable<Boolean> clearTables() {
        return Observable.fromCallable(new Callable<Boolean>() {
            @Override
            public Boolean call() throws Exception {
//               mChamadoDAO.deleteAll();
//               mAtendimentoDAO.deleteAll();
                appDatabase.clearAllTables();
                getPaperBook().clearCurrentChamadoAtendimento();
                getPaperBook().deleteNomesClientes();
                getPaperBook().deleteUsuarioLogado();
                getPaperBook().deleteDataHoraSincronizacaoChamados();
                getPaperBook().setLogginMode(DataManager.LoggedInMode.LOGGED_IN_MODE_LOGGED_OUT);
                return true;
            }
        });
    }

    public Observable<ResponseTransfer<NovoAtendimentoResponse>> saveNewNetworking(AtendimentoModel response) {
        return mAtendimentoService.saveNew(response.toRequest());
    }

    public CurrentChamadoAtendimento inserirNovoAtendimento(NovoAtendimentoResponse result, AtendimentoModel model) {
        ReponseNovoAtendimentoDTO atendimento = result.getAtendimento();
        model.setIdAtendimentoPortal(atendimento.getId());
        model.setAtivoApp(atendimento.getAtivoApp() != null && "1".equals(atendimento.getAtivoApp()));
        model.setSincronizadoApp(atendimento.getSincronizadoApp() != null && "1".equals(atendimento.getSincronizadoApp()));
        model.setUltimaAtualizacaoApp(DateUtils.parseData(atendimento.getAtualizadoApp()));

        long inserted = mAtendimentoDAO.insert(model);
        model.setIdApp(inserted);

        //model.getTimelines().forEach(t -> t.setIdAtendimentoApp(inserted));
            //mTimelineDAO.insertAll(atendimentoModel.getTimelines());

        //-------------------------- Processar Timeline
        TimelineNovoAtendimentoDTO timeline = result.getAtendimento().getTimeline();
        TimelineModel timelineModel = model.getTimelines().get(0);
        timelineModel.setIdAtendimentoApp(inserted);
        timelineModel.setAtualizadoApp(DateUtils.parseData(timeline.getAtualizadoApp()));
        timelineModel.setIdTimelinePortal(timeline.getId());
        timelineModel.setSincronizadoApp(timeline.getSincronizadoApp() != null && "1".equals(timeline.getSincronizadoApp()));
        long insert = mTimelineDAO.insert(timelineModel);
        timelineModel.setIdApp(insert);
        //----------------------------------
        ChamadoModel chamadoModel = mChamadoDAO.findByIdChamadoWeb(result.getId());
        // ----------------- Marca chamado como ativo
        chamadoModel.setAtivoApp(result.getAtivoApp() != null && "1".equals(result.getAtivoApp()));
        chamadoModel.setStatusApp(StatusChamado.ATIVO);
        chamadoModel.setStatusPortal(result.getStatus());
        mChamadoDAO.update(chamadoModel);
        // --------------- Cria o atendimento corrent
        CurrentChamadoAtendimento currentChamadoAtendimento = new CurrentChamadoAtendimento();
        currentChamadoAtendimento.setChamadoModel(chamadoModel);
        currentChamadoAtendimento.setAtendimentoModel(model);

        return currentChamadoAtendimento;
    }


}
