package br.com.softilux.softiluxapp.data.prefs;

import android.content.Context;
import android.content.SharedPreferences;

import javax.inject.Inject;
import javax.inject.Singleton;

import br.com.softilux.softiluxapp.data.DataManager;
import br.com.softilux.softiluxapp.di.ApplicationContext;
import br.com.softilux.softiluxapp.di.PreferenceInfo;
import br.com.softilux.core.utils.constants.AppConstants;

@Singleton
public class AppPreferencesHelper implements PreferencesHelper {

    private static final String PREF_KEY_USER_LOGGED_IN_MODE = "PREF_KEY_USER_LOGGED_IN_MODE";
    private static final String PREF_KEY_CURRENT_USER_ID = "PREF_KEY_CURRENT_USER_ID";
    private static final String PREF_KEY_CURRENT_USER_NAME = "PREF_KEY_CURRENT_USER_NAME";
    private static final String PREF_KEY_CURRENT_USER_EMAIL = "PREF_KEY_CURRENT_USER_EMAIL";
    private static final String PREF_KEY_CURRENT_USER_PROFILE_PIC_URL = "PREF_KEY_CURRENT_USER_PROFILE_PIC_URL";
    private static final String PREF_KEY_ACCESS_TOKEN = "PREF_KEY_ACCESS_TOKEN";
    private static final String PREF_KEY_CHEKIN_INICIO_CHAMADO = "PREF_KEY_CHEKIN_INICIO_CHAMADO";
    private static final String PREF_KEY_CHEKIN_CHEGADA_CLIENTE = "PREF_KEY_CHEKIN_CHEGADA_CLIENTE";
    private static final String PREF_KEY_CHEKIN_INICIO_ATENDIMENTO = "PREF_KEY_CHEKIN_INICIO_ATENDIMENTO";

    private final SharedPreferences mPrefs;

    @Inject
    public AppPreferencesHelper(@ApplicationContext Context context,
                                @PreferenceInfo String prefFileName) {
        mPrefs = context.getSharedPreferences(prefFileName, Context.MODE_PRIVATE);
    }

    @Override
    public Long getCurrentUserId() {
        long userId = mPrefs.getLong(PREF_KEY_CURRENT_USER_ID, AppConstants.NULL_INDEX);
        return userId == AppConstants.NULL_INDEX ? null : userId;
    }

    @Override
    public void setCurrentUserId(Long userId) {
        long id = userId == null ? AppConstants.NULL_INDEX : userId;
        mPrefs.edit().putLong(PREF_KEY_CURRENT_USER_ID, id).apply();
    }

    @Override
    public String getCurrentUserName() {
        return mPrefs.getString(PREF_KEY_CURRENT_USER_NAME, null);
    }

    @Override
    public void setCurrentUserName(String userName) {
        mPrefs.edit().putString(PREF_KEY_CURRENT_USER_NAME, userName).apply();
    }

    @Override
    public String getCurrentUserEmail() {
        return mPrefs.getString(PREF_KEY_CURRENT_USER_EMAIL, null);
    }

    @Override
    public void setCurrentUserEmail(String email) {
        mPrefs.edit().putString(PREF_KEY_CURRENT_USER_EMAIL, email).apply();
    }

    @Override
    public String getCurrentUserProfilePicUrl() {
        return mPrefs.getString(PREF_KEY_CURRENT_USER_PROFILE_PIC_URL, null);
    }

    @Override
    public void setCurrentUserProfilePicUrl(String profilePicUrl) {
        mPrefs.edit().putString(PREF_KEY_CURRENT_USER_PROFILE_PIC_URL, profilePicUrl).apply();
    }

    @Override
    public int getCurrentUserLoggedInMode() {
        return mPrefs.getInt(PREF_KEY_USER_LOGGED_IN_MODE,
                DataManager.LoggedInMode.LOGGED_IN_MODE_LOGGED_OUT.getType());
    }

    @Override
    public void setCurrentUserLoggedInMode(DataManager.LoggedInMode mode) {
        mPrefs.edit().putInt(PREF_KEY_USER_LOGGED_IN_MODE, mode.getType()).apply();
    }

    @Override
    public String getAccessToken() {
        return mPrefs.getString(PREF_KEY_ACCESS_TOKEN, null);
    }

    @Override
    public void setAccessToken(String accessToken) {
        mPrefs.edit().putString(PREF_KEY_ACCESS_TOKEN, accessToken).apply();
    }

    @Override
    public Boolean isCheckInInicioChamado() {
        return mPrefs.getBoolean(PREF_KEY_CHEKIN_INICIO_CHAMADO, false);
    }

    @Override
    public void setCheckInInicioChamado(Boolean isCheckInInicioChamado) {
        mPrefs.edit().putBoolean(PREF_KEY_CHEKIN_INICIO_CHAMADO, isCheckInInicioChamado).apply();
    }

    @Override
    public Boolean isCheckInChegadaCliente() {
        return mPrefs.getBoolean(PREF_KEY_CHEKIN_CHEGADA_CLIENTE, false);
    }

    @Override
    public void setCheckInChegadaCliente(Boolean isCheckInChegadaCliente) {
        mPrefs.edit().putBoolean(PREF_KEY_CHEKIN_CHEGADA_CLIENTE, isCheckInChegadaCliente).apply();
    }

    @Override
    public Boolean isCheckInInicioAtendimento() {
        return mPrefs.getBoolean(PREF_KEY_CHEKIN_INICIO_ATENDIMENTO, false);
    }

    @Override
    public void setCheckInInicioAtendimento(Boolean isCheckInInicioAtendimento) {
        mPrefs.edit().putBoolean(PREF_KEY_CHEKIN_INICIO_ATENDIMENTO, isCheckInInicioAtendimento).apply();
    }
}
