package br.com.softilux.softiluxapp.data.preferences;

import android.content.Context;
import android.content.SharedPreferences;

import javax.inject.Inject;
import javax.inject.Singleton;

import br.com.softilux.core.utils.constants.AppConstants;
import br.com.softilux.softiluxapp.data.DataManager;
import br.com.softilux.softiluxapp.data.db.model.UsuarioLogado;
import br.com.softilux.softiluxapp.di.ApplicationContext;
import br.com.softilux.softiluxapp.di.PreferenceInfo;

/**
 * Created by Vinicius on 11,Abril,2019
 */
@Singleton
public class PrivatePreferences implements Preferences {

    private static final String PREF_KEY_USUARIO_ID = "PREF_KEY_USUAURIO_ID";
    private static final String PREF_KEY_USUARIO_NOME = "PREF_KEY_USUAURIO_NOME";
    private static final String PREF_KEY_USUARIO_EMAIL = "PREF_KEY_USUARIO_EMAIL";
    private static final String PREF_KEY_FILIAL_ID = "PREF_KEY_FILIAL_ID";
    private static final String PREF_KEY_TECNICO_ID = "PREF_KEY_TECNICO_ID";
    private static final String PREF_KEY_EMPRESA_ID = "PREF_KEY_USER_EMPRESA_ID";
    private static final String PREF_KEY_USER_LOGGED_IN_MODE = "PREF_KEY_USER_LOGGED_IN_MODE";
    private final SharedPreferences mPrefs;

    @Inject
    public PrivatePreferences(@ApplicationContext Context context,
                              @PreferenceInfo String prefFileName) {
        mPrefs = context.getSharedPreferences(prefFileName, Context.MODE_PRIVATE);
    }

    @Override
    public Long getUsuarioId() {
        long usuarioId = mPrefs.getLong(PREF_KEY_USUARIO_ID, AppConstants.NULL_INDEX);
        return usuarioId == AppConstants.NULL_INDEX ? null : usuarioId;
    }

    @Override
    public void setUsuarioId(Long usuarioId) {
        long id = usuarioId == null ? AppConstants.NULL_INDEX : usuarioId;
        mPrefs.edit().putLong(PREF_KEY_USUARIO_ID, id).apply();
    }

    @Override
    public Long getEmpresaId() {
        long empresaId = mPrefs.getLong(PREF_KEY_EMPRESA_ID, AppConstants.NULL_INDEX);
        return empresaId == AppConstants.NULL_INDEX ? null : empresaId;
    }

    @Override
    public void setEmpresaId(Long empresaId) {
        long id = empresaId == null ? AppConstants.NULL_INDEX : empresaId;
        mPrefs.edit().putLong(PREF_KEY_EMPRESA_ID, id).apply();
    }

    @Override
    public String getTecnicoId() {
        return mPrefs.getString(PREF_KEY_TECNICO_ID, null);
    }

    @Override
    public void setNomeSuporte(String nomeSuporte) {
        mPrefs.edit().putString(PREF_KEY_TECNICO_ID, nomeSuporte).apply();
    }

    @Override
    public void logoutUser() {
        removerAutenticacao();
        setCurrentUserLoggedInMode(DataManager.LoggedInMode.LOGGED_IN_MODE_LOGGED_OUT);
    }

    private void removerAutenticacao() {
        SharedPreferences.Editor editor = mPrefs.edit();

        editor.remove(PREF_KEY_USUARIO_ID);
        editor.remove(PREF_KEY_USUARIO_NOME);
        editor.remove(PREF_KEY_USUARIO_EMAIL);
        editor.remove(PREF_KEY_EMPRESA_ID);
        editor.remove(PREF_KEY_FILIAL_ID);
        editor.remove(PREF_KEY_TECNICO_ID);

        editor.apply();
    }

    @Override
    public int getCurrentUserLoggedInMode() {
        return mPrefs.getInt(PREF_KEY_USER_LOGGED_IN_MODE, DataManager.LoggedInMode.LOGGED_IN_MODE_LOGGED_OUT.getType());
    }

    @Override
    public void setCurrentUserLoggedInMode(DataManager.LoggedInMode mode) {
        mPrefs.edit().putInt(PREF_KEY_USER_LOGGED_IN_MODE, mode.getType()).apply();
    }

    @Override
    public void setUsuarioLogado(UsuarioLogado user) {
        setUsuarioId(user.getId());
        setEmpresaId(user.getIdEmpresa());
        setNomeSuporte(user.getIdTecnico());
        setEmail(user.getEmail());
        setNome(user.getNome());
        setFilialId(user.getIdFilial());
    }

    @Override
    public UsuarioLogado getUsuarioLogado() {
        UsuarioLogado usuarioLogado = new UsuarioLogado();

        usuarioLogado.setNome(getNome());
        usuarioLogado.setEmail(getEmail());
        usuarioLogado.setIdEmpresa(getEmpresaId());
        usuarioLogado.setIdTecnico(getTecnicoId());
        usuarioLogado.setEmail(getEmail());
        usuarioLogado.setIdFilial(getFilialId());

        return usuarioLogado;
    }

    @Override
    public void setEmail(String email) {
        mPrefs.edit().putString(PREF_KEY_USUARIO_EMAIL, email).apply();
    }

    @Override
    public String getEmail() {
        return mPrefs.getString(PREF_KEY_USUARIO_EMAIL, null);
    }

    @Override
    public void setNome(String nome) {
        mPrefs.edit().putString(PREF_KEY_USUARIO_NOME, nome).apply();
    }

    @Override
    public String getNome() {
        return mPrefs.getString(PREF_KEY_USUARIO_NOME, null);
    }

    @Override
    public void setFilialId(Long filialId) {
        long id = filialId == null ? AppConstants.NULL_INDEX : filialId;
        mPrefs.edit().putLong(PREF_KEY_FILIAL_ID, id).apply();
    }

    @Override
    public Long getFilialId() {
        long filialId = mPrefs.getLong(PREF_KEY_FILIAL_ID, AppConstants.NULL_INDEX);
        return filialId == AppConstants.NULL_INDEX ? null : filialId;
    }

}
