package br.com.softilux.softiluxapp.data.nosql;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;

import javax.inject.Inject;
import javax.inject.Singleton;

import br.com.softilux.softiluxapp.data.DataManager;
import br.com.softilux.softiluxapp.data.db.model.CurrentChamadoAtendimento;
import br.com.softilux.softiluxapp.data.db.model.UsuarioLogado;
import io.paperdb.Paper;

/**
 * Created by Vinicius on 17,Maio,2019
 */
@Singleton
public class PaperBook implements IPaperBook {

    private final String LOGGIN_MODE = "loginMode";

    private final String LOGGED_USER = "loggedUser";

    private final String DT_SINCRONIZACAO_CHAMADOS = "dataSincronizacaoChamados";

    private final String CURRENT_CHAMADO_ATENDIMENTO = "currentChamadoAtendimento";

    private final String FILTRO_CLIENTES = "clientesFilter";

    @Inject
    public PaperBook() {
    }

    @Override
    public void salvarNomesClientes(Set<String> nomes) {
        // Ler dados antes de salvar, para fazer o merge
        Set<String> clientesSalvados = Paper.book().read(FILTRO_CLIENTES, new HashSet<>());
        clientesSalvados.addAll(nomes);
        Paper.book().write(FILTRO_CLIENTES, clientesSalvados);
    }

    @Override
    public Set<String> getNomesClientes() {
        return readNomesClientes();
    }

    @Override
    public String[] getNomesClientesAsArray() {
        Set<String> clientes = readNomesClientes();
        return clientes.toArray(new String[0]);
    }

    private Set<String> readNomesClientes() {
        return Paper.book().read(FILTRO_CLIENTES);
    }

    @Override
    public void deleteNomesClientes() {
        Paper.book().delete(FILTRO_CLIENTES);
    }

    @Override
    public void setLogginMode(DataManager.LoggedInMode logginMode) {
        Paper.book().write(LOGGIN_MODE, logginMode);
    }

    @Override
    public DataManager.LoggedInMode getLogginMode() {
        return Paper.book().read(LOGGIN_MODE, DataManager.LoggedInMode.LOGGED_IN_MODE_LOGGED_OUT);
    }

    @Override
    public void deleteLogginMode() {
        Paper.book().delete(LOGGIN_MODE);
    }

    @Override
    public void salvarUsuarioLogado(UsuarioLogado usuarioLogado) {
        Paper.book().write(LOGGED_USER, usuarioLogado);
    }

    @Override
    public UsuarioLogado getUsuarioLogado() {
        return Paper.book().read(LOGGED_USER);
    }

    @Override
    public void deleteUsuarioLogado() {
        Paper.book().delete(LOGGED_USER);
    }

    @Override
    public void setDataHoraSincronizacaoChamados(Date date) {
        Paper.book().write(DT_SINCRONIZACAO_CHAMADOS, date);
    }

    @Override
    public void getDataHoraSincronizacaoChamados() {
        Paper.book().read(DT_SINCRONIZACAO_CHAMADOS);
    }

    @Override
    public void deleteDataHoraSincronizacaoChamados() {
        Paper.book().delete(DT_SINCRONIZACAO_CHAMADOS);
    }

    @Override
    public void salvarCurrentAtendimento(CurrentChamadoAtendimento currentChamadoAtendimento) {
        Paper.book().write(CURRENT_CHAMADO_ATENDIMENTO, currentChamadoAtendimento);
    }

    @Override
    public CurrentChamadoAtendimento getCurrentAtendimento() {
        return Paper.book().read(CURRENT_CHAMADO_ATENDIMENTO);
    }

    @Override
    public void clearCurrentChamadoAtendimento() {
        Paper.book().delete(CURRENT_CHAMADO_ATENDIMENTO);
    }

}
