package br.com.softilux.softiluxapp.data.network;

import br.com.softilux.softiluxapp.data.network.model.BlogResponse;
import br.com.softilux.softiluxapp.data.network.model.LoginRequest;
import br.com.softilux.softiluxapp.data.network.model.LoginResponse;
import br.com.softilux.softiluxapp.data.network.model.LogoutResponse;
import br.com.softilux.softiluxapp.data.network.model.OpenSourceResponse;
import io.reactivex.Single;

public interface ApiHelper {

    ApiHeader getApiHeader();

    Single<LoginResponse> doGoogleLoginApiCall(LoginRequest.GoogleLoginRequest request);

    Single<LoginResponse> doFacebookLoginApiCall(LoginRequest.FacebookLoginRequest request);

    Single<LoginResponse> doServerLoginApiCall(LoginRequest.ServerLoginRequest request);

    Single<LogoutResponse> doLogoutApiCall();

    Single<BlogResponse> getBlogApiCall();

    Single<OpenSourceResponse> getOpenSourceApiCall();
}
