package br.com.softilux.softiluxapp.data.db.model.representation;

import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.List;

import br.com.softilux.softiluxapp.R;

/**
 * Created by Vinicius on 26,Janeiro,2019
 */
public enum StatusChamado {

    ATIVO("Ativo", R.color.teal),
    ATRASADOS("Atrasados", R.color.bootstrap_brand_danger),
    EM_MANUTENCAO("Em Manutenção", R.color.bootstrap_brand_warning),
    LIBERADO_PARA_ATENDIMENTO("Liberados para atendimento", android.R.color.holo_blue_dark),
    CONCLUIDOS("Concluído", android.R.color.holo_blue_dark),
    ABERTO("Aberto", R.color.indigo),
    PENDENTE("Pendente", android.R.color.holo_blue_dark),
    DESPACHADO("Despachado", android.R.color.holo_blue_dark);

    private String status;

    private int color;

    StatusChamado(String status, int color) {
        this.status = status;
        this.color = color;
    }

    public static StatusChamado getEnum(String status) {
        if (status == null || status.length() == 0)
            return null;

        return Enum.valueOf(StatusChamado.class, status);
    }

    public static StatusChamado getEnumFromStatus(String status) {
        if (StringUtils.isBlank(status)) return null;

        for (StatusChamado statusChamado : StatusChamado.values()) {
            if (statusChamado.getStatus().equalsIgnoreCase(status)) {
                return statusChamado;
            }
        }

        return null;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public int getColor() {
        return color;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public static List<String> getStatusLiberadosParaAtendimento() {
        List<String> liberadosAtendimento = new ArrayList<>();

        liberadosAtendimento.add(ABERTO.getStatus());
        liberadosAtendimento.add(DESPACHADO.getStatus());
        liberadosAtendimento.add(EM_MANUTENCAO.getStatus());
        liberadosAtendimento.add(LIBERADO_PARA_ATENDIMENTO.getStatus());
        liberadosAtendimento.add(PENDENTE.getStatus());

        return liberadosAtendimento;
    }
}
