package br.com.softilux.softiluxapp.data.db.model.representation;

import org.apache.commons.lang3.StringUtils;

/**
 * Created by Vinicius on 18,Abril,2019
 */
public enum Modalidade {

    SUPRIMENTO(0,"Suprimento"),
    ASSISTENCIA_CHAMADO_TECNICO(1,"Assistência/Chamado Técnico"),
    SOLICITACAO_RETIRADA_INSTALACAO_OUTROS(2, "Solicitação (Retirada/Instalação/Outros)");

    private int codigo;
    private String nome;

    Modalidade(int codigo, String nome) {
        this.codigo = codigo;
        this.nome = nome;
    }

    public int getCodigo() {
        return codigo;
    }

    public String getNome() {
        return nome;
    }

    public static Modalidade fromValue(String codigo) {
        if (StringUtils.isBlank(codigo)) return null;

        for (Modalidade m : Modalidade.values()) {
            if (String.valueOf(m.codigo).equalsIgnoreCase(codigo))  {
                return m;
            }
        }
        return null;
    }
}
