package br.com.softilux.softiluxapp.data.db.model.representation;

import org.apache.commons.lang3.StringUtils;

import br.com.softilux.softiluxapp.R;

/**
 * Created by Vinicius on 04,Maio,2019
 */
public enum ChamadoStatus {

    A("Abertura", R.drawable.rectangle_oval_teal),
    E("Despachado", R.drawable.rectangle_oval_blue),
    D("Despachado", R.drawable.rectangle_oval_blue),
    P("Pendente", R.drawable.rectangle_oval_blue_holo),
    M("Em Manutenção", R.drawable.rectangle_oval_yellow),
    C("Cancelado", android.R.color.holo_blue_dark),
    O("Concluído", android.R.color.holo_blue_dark);

    private String status;

    private int colorLabel;

    ChamadoStatus(String status, int colorLabel) {
        this.status = status;
        this.colorLabel = colorLabel;
    }

    public String getStatus() {
        return status;
    }

    public int getColorLabel() {
        return colorLabel;
    }

    public void setColorLabel(int colorLabel) {
        this.colorLabel = colorLabel;
    }

    public static ChamadoStatus fromValue(String status) {
        if (StringUtils.isBlank(status)) return null;

        for (ChamadoStatus m : ChamadoStatus.values()) {
            if (String.valueOf(m.name()).equalsIgnoreCase(status))  {
                return m;
            }
        }
        return null;
    }

}
