package br.com.softilux.softiluxapp.data.db.model;

import android.arch.persistence.room.ColumnInfo;
import android.arch.persistence.room.Embedded;
import android.arch.persistence.room.Entity;
import android.arch.persistence.room.ForeignKey;
import android.arch.persistence.room.Index;
import android.arch.persistence.room.PrimaryKey;

import com.blankj.utilcode.util.TimeUtils;

import org.jetbrains.annotations.NotNull;

import java.util.Date;

import br.com.softilux.core.utils.DateUtils;
import br.com.softilux.softiluxapp.transfer.datatransfer.finalizaratendimento.Timeline;
import br.com.softilux.softiluxapp.transfer.datatransfer.reiniciaratendimento.AtendimentoReiniciadoDTORequest;
import br.com.softilux.softiluxapp.transfer.datatransfer.reiniciaratendimento.AtendimentoReiniciadoDTOResponse;
import br.com.softilux.softiluxapp.transfer.datatransfer.reiniciaratendimento.TimelineAtendimentoReiniciadoDTO;
import br.com.softilux.softiluxapp.transfer.datatransfer.CadastrarNovaTimelineNetworkingRequest;
import br.com.softilux.softiluxapp.transfer.services.TimelineRequestResponse;
import br.com.softilux.softiluxapp.ui.chamado.AndamentoAtendimentoEnum;

/**
 * Created by Vinicius on 22,Maio,2019
 */
@Entity(tableName = "timelines_atendimento", foreignKeys = @ForeignKey(entity = AtendimentoModel.class,
        parentColumns = "id_app",
        childColumns = "id_atendimento_app",
        onDelete = ForeignKey.CASCADE)
    ,indices = @Index(name = "idx_atendimento_timeline" , value = "id_atendimento_app"))
public class TimelineModel {

    @PrimaryKey(autoGenerate = true)
    @ColumnInfo(name = "id_app")
    private Long idApp;

    @ColumnInfo(name = "id_timeline_portal")
    private Long idTimelinePortal;

    @ColumnInfo(name = "andamento_chamado_snapshot")
    private AndamentoAtendimentoEnum andamentoSnapshot;

    @ColumnInfo(name = "tipo_time_line")
    private TipoInclusaoTimeLine tipoTimeLine;

    @ColumnInfo(name = "create_at")
    private Date createAt;

    @ColumnInfo(name = "motivo")
    private String motivo;

    @ColumnInfo(name = "motivo_outros")
    private String motivoOutros;

    @ColumnInfo(name = "id_atendimento_portal")
    private Long idAtendimentoPortal;

    @ColumnInfo(name = "id_atendimento_app")
    private Long idAtendimentoApp;

    @ColumnInfo(name = "id_tecnico")
    private String idTecnico;

    @ColumnInfo(name = "id_base")
    private Long idBase;

    @ColumnInfo(name = "ATUALIZADO_APP")
    private Date atualizadoApp;

    @ColumnInfo(name = "SINCRONIZADO_APP")
    private Boolean sincronizadoApp;

    @Embedded
    private LocationCapture locationCapture;



    public Long getIdApp() {
        return idApp;
    }

    public void setIdApp(Long idApp) {
        this.idApp = idApp;
    }

    public Long getIdTimelinePortal() {
        return idTimelinePortal;
    }

    public void setIdTimelinePortal(Long idTimelinePortal) {
        this.idTimelinePortal = idTimelinePortal;
    }

    public AndamentoAtendimentoEnum getAndamentoSnapshot() {
        return andamentoSnapshot;
    }

    public void setAndamentoSnapshot(AndamentoAtendimentoEnum andamentoSnapshot) {
        this.andamentoSnapshot = andamentoSnapshot;
    }

    public TipoInclusaoTimeLine getTipoTimeLine() {
        return tipoTimeLine;
    }

    public void setTipoTimeLine(TipoInclusaoTimeLine tipoTimeLine) {
        this.tipoTimeLine = tipoTimeLine;
    }

    public Date getCreateAt() {
        return createAt;
    }

    public void setCreateAt(Date createAt) {
        this.createAt = createAt;
    }

    public String getMotivo() {
        return motivo;
    }

    public void setMotivo(String motivo) {
        this.motivo = motivo;
    }

    public String getMotivoOutros() {
        return motivoOutros;
    }

    public void setMotivoOutros(String motivoOutros) {
        this.motivoOutros = motivoOutros;
    }

    public Long getIdAtendimentoPortal() {
        return idAtendimentoPortal;
    }

    public void setIdAtendimentoPortal(Long idAtendimentoPortal) {
        this.idAtendimentoPortal = idAtendimentoPortal;
    }

    public Long getIdAtendimentoApp() {
        return idAtendimentoApp;
    }

    public void setIdAtendimentoApp(Long idAtendimentoApp) {
        this.idAtendimentoApp = idAtendimentoApp;
    }

    public LocationCapture getLocationCapture() {
        return locationCapture;
    }

    public void setLocationCapture(LocationCapture locationCapture) {
        this.locationCapture = locationCapture;
    }

    public String getIdTecnico() {
        return idTecnico;
    }

    public void setIdTecnico(String idTecnico) {
        this.idTecnico = idTecnico;
    }

    public Long getIdBase() {
        return idBase;
    }

    public void setIdBase(Long idBase) {
        this.idBase = idBase;
    }

    public Date getAtualizadoApp() {
        return atualizadoApp;
    }

    public void setAtualizadoApp(Date atualizadoApp) {
        this.atualizadoApp = atualizadoApp;
    }

    public Boolean getSincronizadoApp() {
        return sincronizadoApp;
    }

    public void setSincronizadoApp(Boolean sincronizadoApp) {
        this.sincronizadoApp = sincronizadoApp;
    }

    public static TimelineModel cadastrarNovaTimeline(TimelineRequestResponse responseNetworking,
                                                       CadastrarNovaTimelineNetworkingRequest requestNetworking,
                                                       AtendimentoModel currentAtendimento) {
        TimelineModel timelineModel = new TimelineModel();

        timelineModel.setIdAtendimentoPortal(requestNetworking.getIdAtendimentoPortal());
        timelineModel.setIdTecnico(requestNetworking.getIdTecnico());
        timelineModel.setIdAtendimentoApp(currentAtendimento.getIdApp());
        timelineModel.setMotivo(requestNetworking.getMotivo());
        timelineModel.setMotivoOutros(requestNetworking.getMotivoOutros());
        timelineModel.setAndamentoSnapshot(requestNetworking.getAndamentoSnapshot());
        timelineModel.setTipoTimeLine(requestNetworking.getTipoTimeLine());
        timelineModel.setCreateAt(DateUtils.parseDatayyyyMMddHHmmss(requestNetworking.getCreateAt()));
        timelineModel.setSincronizadoApp(responseNetworking.getSincronizadoApp() != null && "1".equals(responseNetworking.getSincronizadoApp()));
        timelineModel.setAtualizadoApp(DateUtils.parseData(responseNetworking.getAtualizadoApp()));
        timelineModel.setIdTimelinePortal(responseNetworking.getIdTimelinePortal());
        timelineModel.setIdBase(currentAtendimento.getIdBase());

        return timelineModel;
    }

    public static TimelineModel cadastrarNovaTimeline(Timeline responseNetworking,
                                                      CadastrarNovaTimelineNetworkingRequest requestNetworking,
                                                      AtendimentoModel currentAtendimento) {
        TimelineModel timelineModel = new TimelineModel();

        timelineModel.setIdAtendimentoPortal(requestNetworking.getIdAtendimentoPortal());
        timelineModel.setIdTecnico(requestNetworking.getIdTecnico());
        timelineModel.setIdAtendimentoApp(currentAtendimento.getIdApp());
        timelineModel.setMotivo(requestNetworking.getMotivo());
        timelineModel.setMotivoOutros(requestNetworking.getMotivoOutros());
        timelineModel.setAndamentoSnapshot(requestNetworking.getAndamentoSnapshot());
        timelineModel.setTipoTimeLine(requestNetworking.getTipoTimeLine());
        timelineModel.setCreateAt(DateUtils.parseDatayyyyMMddHHmmss(requestNetworking.getCreateAt()));
        timelineModel.setSincronizadoApp(responseNetworking.getSincronizadoApp() != null && "1".equals(responseNetworking.getSincronizadoApp()));
        timelineModel.setAtualizadoApp(DateUtils.parseData(responseNetworking.getAtualizadoApp()));
        timelineModel.setIdTimelinePortal(currentAtendimento.getIdAtendimentoPortal());
        timelineModel.setIdBase(currentAtendimento.getIdBase());

        return timelineModel;
    }

    public static TimelineModel cadastrarNovaTimeline(AtendimentoReiniciadoDTOResponse responseNetworking,
                                                      AtendimentoReiniciadoDTORequest requestNetworking,
                                                      AtendimentoModel currentAtendimento) {
        TimelineAtendimentoReiniciadoDTO timelinePortal = responseNetworking.getTimelineAtendimentoReiniciadoDTO();
        CadastrarNovaTimelineNetworkingRequest timelineRequest = requestNetworking.getNetworkingRequest();
        TimelineModel timelineModel = new TimelineModel();
        timelineModel.setIdAtendimentoPortal(requestNetworking.getIdAtendimentoPortal());
        timelineModel.setIdTecnico(currentAtendimento.getNomeAtendente());
        timelineModel.setIdAtendimentoApp(currentAtendimento.getIdApp());
        timelineModel.setMotivo(timelineRequest.getMotivo());
        timelineModel.setMotivoOutros(timelineRequest.getMotivoOutros());
        timelineModel.setAndamentoSnapshot(timelineRequest.getAndamentoSnapshot());
        timelineModel.setTipoTimeLine(timelineRequest.getTipoTimeLine());
        timelineModel.setCreateAt(DateUtils.parseDatayyyyMMddHHmmss(timelineRequest.getCreateAt()));
        timelineModel.setSincronizadoApp(timelinePortal.getSincronizadoApp() != null && "1".equals(timelinePortal.getSincronizadoApp()));
        timelineModel.setAtualizadoApp(DateUtils.parseData(timelinePortal.getAtualizadoApp()));
        timelineModel.setIdTimelinePortal(timelinePortal.getId());
        timelineModel.setIdBase(currentAtendimento.getIdBase());
        timelineModel.setLocationCapture(new LocationCapture(timelineRequest));

        return timelineModel;
    }

    public static TimelineModel cadastrarNovaTimeline(AtendimentoReiniciadoDTOResponse responseNetworking,
                                                      CadastrarNovaTimelineNetworkingRequest requestNetworking,
                                                      AtendimentoModel currentAtendimento) {
        TimelineAtendimentoReiniciadoDTO timelinePortal = responseNetworking.getTimelineAtendimentoReiniciadoDTO();
        TimelineModel timelineModel = new TimelineModel();
        timelineModel.setIdAtendimentoPortal(requestNetworking.getIdAtendimentoPortal());
        timelineModel.setIdTecnico(requestNetworking.getIdTecnico());
        timelineModel.setIdAtendimentoApp(currentAtendimento.getIdApp());
        timelineModel.setMotivo(requestNetworking.getMotivo());
        timelineModel.setMotivoOutros(requestNetworking.getMotivoOutros());
        timelineModel.setAndamentoSnapshot(requestNetworking.getAndamentoSnapshot());
        timelineModel.setTipoTimeLine(requestNetworking.getTipoTimeLine());
        timelineModel.setCreateAt(DateUtils.parseDatayyyyMMddHHmmss(requestNetworking.getCreateAt()));
        timelineModel.setSincronizadoApp(timelinePortal.getSincronizadoApp() != null && "1".equals(timelinePortal.getSincronizadoApp()));
        timelineModel.setAtualizadoApp(DateUtils.parseData(timelinePortal.getAtualizadoApp()));
        timelineModel.setIdTimelinePortal(timelinePortal.getId());
        timelineModel.setIdBase(currentAtendimento.getIdBase());

        return timelineModel;
    }

    public static TimelineModel reiniciarChamado(AtendimentoModel atendimentoModel, AndamentoAtendimentoEnum chamadoReiniciado, String motivo) {
        TimelineModel timelineModel = new TimelineModel();

        timelineModel.setIdAtendimentoPortal(atendimentoModel.getIdAtendimentoPortal());
        timelineModel.setIdTecnico(atendimentoModel.getNomeAtendente());
        timelineModel.setIdAtendimentoApp(atendimentoModel.getIdApp());
        timelineModel.setMotivo(motivo);
        timelineModel.setMotivoOutros("");
        timelineModel.setAndamentoSnapshot(chamadoReiniciado);
        timelineModel.setTipoTimeLine(TipoInclusaoTimeLine.INCLUSAO_PROGRESSO_APP);
        timelineModel.setCreateAt(TimeUtils.getNowDate());
        timelineModel.setSincronizadoApp(false);
        timelineModel.setAtualizadoApp(null);
        timelineModel.setIdBase(atendimentoModel.getIdBase());

        return timelineModel;
    }

    public boolean podeSerApresentadoNaListagem() {
        return getAndamentoSnapshot() != null && getTipoTimeLine() == TipoInclusaoTimeLine.INCLUSAO_PROGRESSO_APP;
    }

    @NotNull
    public static TimelineModel iniciarNovoAtendimento(AtendimentoModel atendimentoModel) {
        TimelineModel timelineModel = new TimelineModel();
        timelineModel.setCreateAt(TimeUtils.getNowDate());
        timelineModel.setTipoTimeLine(TipoInclusaoTimeLine.INCLUSAO_CHAMADO_INICIADO);
        timelineModel.setIdTecnico(atendimentoModel.getNomeAtendente());
        timelineModel.setIdBase(atendimentoModel.getIdBase());

        return timelineModel;
    }
}
