package br.com.softilux.softiluxapp.data.db.model;

import android.location.Address;

import br.com.softilux.softiluxapp.transfer.datatransfer.CadastrarNovaTimelineNetworkingRequest;

/**
 * Created by Vinicius on 22,Maio,2019
 */
public class LocationCapture {

    private String address;

    private Double latitute;

    private Double longitute;

    private Boolean locationCaptured;

    private String countryName;

    private String locality;

    public LocationCapture() {}

    public LocationCapture(Address address) {
        boolean localizacaoCapturada = address != null;
        this.locationCaptured = localizacaoCapturada;
        if (localizacaoCapturada) {
            this.address = address.getAddressLine(0);
            this.latitute = address.getLatitude();
            this.longitute = address.getLongitude();
            this.countryName = address.getCountryName();
            this.locality = address.getLocality();
        }
    }

    public LocationCapture(boolean localizacaoEncontrada) {
        this.locationCaptured = localizacaoEncontrada;
    }

    public LocationCapture(CadastrarNovaTimelineNetworkingRequest networkingRequest) {
        if (networkingRequest != null) {
            this.address = networkingRequest.getAddress();
            this.countryName = networkingRequest.getCountryName();
            this.longitute = networkingRequest.getLongitute();
            this.latitute = networkingRequest.getLatitute();
            this.locality = networkingRequest.getLocality();
            this.locationCaptured = networkingRequest.getLocationCaptured();
        }
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Double getLatitute() {
        return latitute;
    }

    public void setLatitute(Double latitute) {
        this.latitute = latitute;
    }

    public Double getLongitute() {
        return longitute;
    }

    public void setLongitute(Double longitute) {
        this.longitute = longitute;
    }

    public Boolean getLocationCaptured() {
        return locationCaptured;
    }

    public void setLocationCaptured(Boolean locationCaptured) {
        this.locationCaptured = locationCaptured;
    }

    public String getCountryName() {
        return countryName;
    }

    public void setCountryName(String countryName) {
        this.countryName = countryName;
    }

    public String getLocality() {
        return locality;
    }

    public void setLocality(String locality) {
        this.locality = locality;
    }

    @Override
    public String toString() {
        return "LocationCapture{" +
                "address='" + address + '\'' +
                ", latitute=" + latitute +
                ", longitute=" + longitute +
                ", locationCaptured=" + locationCaptured +
                ", countryName='" + countryName + '\'' +
                ", locality='" + locality + '\'' +
                '}';
    }
}
