package br.com.softilux.softiluxapp.data.db.model;

import android.arch.persistence.room.ColumnInfo;
import android.arch.persistence.room.Entity;
import android.arch.persistence.room.PrimaryKey;

import com.google.gson.annotations.SerializedName;

import org.apache.commons.lang3.math.NumberUtils;
import org.jetbrains.annotations.Nullable;

import java.util.Calendar;
import java.util.Date;

import br.com.softilux.core.utils.DateUtils;
import br.com.softilux.softiluxapp.data.db.model.representation.ChamadoStatus;
import br.com.softilux.softiluxapp.data.db.model.representation.Modalidade;
import br.com.softilux.softiluxapp.data.db.model.representation.StatusChamado;

/**
 * Created by Vinicius on 30,Abril,2019
 */
@Entity(tableName = "chamados")
public class ChamadoModel {

    @PrimaryKey(autoGenerate = true)
    @ColumnInfo(name = "id_app")
    private Long idApp;

    @ColumnInfo(name = "id_chamado_web")
    private Long idChamadoWeb;

    /**
     *  Id origem portal web.
     * */
    @ColumnInfo(name = "seq_origem")
    private Long seqOrigem;
    /**
     *  Id origem softilux.
     * */
    @ColumnInfo(name = "seq_os")
    private Long seqOS;
    @ColumnInfo(name = "empresa_id")
    private Long empresaId;
    @ColumnInfo(name = "data_inclusao")
    private String dataInclusao;
    @ColumnInfo(name = "hora_inclusao")
    private String horaInclusao;
    @ColumnInfo(name = "data_previsao_atendimento")
    private String dataPrevisao;
    @ColumnInfo(name = "hora_previsao_atendimento")
    private String horaPrevisao;
    @ColumnInfo(name = "contato")
    private String contato;
    @ColumnInfo(name = "cd_empresa")
    private Long cdEmpresa;
    @ColumnInfo(name = "cd_cliente")
    private Long cdCliente;
    @ColumnInfo(name = "nm_cliente")
    private String nmCliente;
    @ColumnInfo(name = "cidade")
    private String cidade;
    @ColumnInfo(name = "endereco")
    private String endereco;
    @ColumnInfo(name = "complemento")
    private String complemento;
    @ColumnInfo(name = "bairro")
    private String bairro;
    @ColumnInfo(name = "uf")
    private String uf;
    @ColumnInfo(name = "cep")
    private String cep;
    @ColumnInfo(name = "ddd")
    private String ddd;
    @ColumnInfo(name = "fone")
    private String fone;
    @ColumnInfo(name = "celular")
    private String celular;
    @ColumnInfo(name = "email")
    private String email;
    @ColumnInfo(name = "cd_equipamento")
    private Long cdEquipamento;
    @ColumnInfo(name = "status_portal")
    private ChamadoStatus statusPortal;
    @ColumnInfo(name = "status_app")
    private StatusChamado statusApp;
    @ColumnInfo(name = "cd_status")
    private String cdStatus;
    @ColumnInfo(name = "nm_suporte")
    private String nmSuporte;
    @ColumnInfo(name = "tipo_os")
    private Modalidade modalidadeOs;
    @ColumnInfo(name = "obs_defeito_cliente")
    private String observacaoDefeitoCli;
    @ColumnInfo(name = "nm_defeito")
    private String nmDefeito;
    @ColumnInfo(name = "nm_os_tp")
    private String nmOSTp;
    @ColumnInfo(name = "serie_equipamento")
    private String serieEquipamento;
    @ColumnInfo(name = "patrimonio")
    private String patrimonio;
    @ColumnInfo(name = "modelo")
    private String modelo;
    @ColumnInfo(name = "departamento")
    private String departamento;
    @ColumnInfo(name = "local_instalacao")
    private String localInstalacao;
    @ColumnInfo(name = "id_base")
    private Long idBase;
    @ColumnInfo(name = "count_atendimentos_realizados")
    private Integer countAtendimentosRealizados;
    @ColumnInfo(name = "ativo_app")
    private Boolean ativoApp;
    @ColumnInfo(name = "follow_up_tecnico")
    private String followUpTecnico;

    public Long getIdApp() {
        return idApp;
    }

    public void setIdApp(Long idApp) {
        this.idApp = idApp;
    }

    public Long getIdChamadoWeb() {
        return idChamadoWeb;
    }

    public void setIdChamadoWeb(Long idChamadoWeb) {
        this.idChamadoWeb = idChamadoWeb;
    }

    public Long getSeqOrigem() {
        return seqOrigem;
    }

    public void setSeqOrigem(Long seqOrigem) {
        this.seqOrigem = seqOrigem;
    }

    public Long getSeqOS() {
        return seqOS;
    }

    public void setSeqOS(Long seqOS) {
        this.seqOS = seqOS;
    }

    public Long getEmpresaId() {
        return empresaId;
    }

    public void setEmpresaId(Long empresaId) {
        this.empresaId = empresaId;
    }

    public String getDataInclusao() {
        return dataInclusao;
    }

    public void setDataInclusao(String dataInclusao) {
        this.dataInclusao = dataInclusao;
    }

    public String getHoraInclusao() {
        return horaInclusao;
    }

    public void setHoraInclusao(String horaInclusao) {
        this.horaInclusao = horaInclusao;
    }

    public String getDataPrevisao() {
        return dataPrevisao;
    }

    public void setDataPrevisao(String dataPrevisao) {
        this.dataPrevisao = dataPrevisao;
    }

    public String getHoraPrevisao() {
        return horaPrevisao;
    }

    public void setHoraPrevisao(String horaPrevisao) {
        this.horaPrevisao = horaPrevisao;
    }

    public String getContato() {
        return contato;
    }

    public void setContato(String contato) {
        this.contato = contato;
    }

    public Long getCdEmpresa() {
        return cdEmpresa;
    }

    public void setCdEmpresa(Long cdEmpresa) {
        this.cdEmpresa = cdEmpresa;
    }

    public Long getCdCliente() {
        return cdCliente;
    }

    public void setCdCliente(Long cdCliente) {
        this.cdCliente = cdCliente;
    }

    public String getNmCliente() {
        return nmCliente;
    }

    public void setNmCliente(String nmCliente) {
        this.nmCliente = nmCliente;
    }

    public String getCidade() {
        return cidade;
    }

    public void setCidade(String cidade) {
        this.cidade = cidade;
    }

    public String getEndereco() {
        return endereco;
    }

    public void setEndereco(String endereco) {
        this.endereco = endereco;
    }

    public String getComplemento() {
        return complemento;
    }

    public void setComplemento(String complemento) {
        this.complemento = complemento;
    }

    public String getBairro() {
        return bairro;
    }

    public void setBairro(String bairro) {
        this.bairro = bairro;
    }

    public String getUf() {
        return uf;
    }

    public void setUf(String uf) {
        this.uf = uf;
    }

    public String getCep() {
        return cep;
    }

    public void setCep(String cep) {
        this.cep = cep;
    }

    public String getDdd() {
        return ddd;
    }

    public void setDdd(String ddd) {
        this.ddd = ddd;
    }

    public String getFone() {
        return fone;
    }

    public void setFone(String fone) {
        this.fone = fone;
    }

    public String getCelular() {
        return celular;
    }

    public void setCelular(String celular) {
        this.celular = celular;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Long getCdEquipamento() {
        return cdEquipamento;
    }

    public void setCdEquipamento(Long cdEquipamento) {
        this.cdEquipamento = cdEquipamento;
    }

    public ChamadoStatus getStatusPortal() {
        return statusPortal;
    }

    public void setStatusPortal(ChamadoStatus statusPortal) {
        this.statusPortal = statusPortal;
    }

    public StatusChamado getStatusApp() {
        return statusApp;
    }

    public void setStatusApp(StatusChamado statusApp) {
        this.statusApp = statusApp;
    }

    public String getCdStatus() {
        return cdStatus;
    }

    public void setCdStatus(String cdStatus) {
        this.cdStatus = cdStatus;
    }

    public String getNmSuporte() {
        return nmSuporte;
    }

    public void setNmSuporte(String nmSuporte) {
        this.nmSuporte = nmSuporte;
    }

    public Modalidade getModalidadeOs() {
        return modalidadeOs;
    }

    public void setModalidadeOs(Modalidade modalidadeOs) {
        this.modalidadeOs = modalidadeOs;
    }

    public String getObservacaoDefeitoCli() {
        return observacaoDefeitoCli;
    }

    public void setObservacaoDefeitoCli(String observacaoDefeitoCli) {
        this.observacaoDefeitoCli = observacaoDefeitoCli;
    }

    public String getNmDefeito() {
        return nmDefeito;
    }

    public void setNmDefeito(String nmDefeito) {
        this.nmDefeito = nmDefeito;
    }

    public String getNmOSTp() {
        return nmOSTp;
    }

    public void setNmOSTp(String nmOSTp) {
        this.nmOSTp = nmOSTp;
    }

    public String getSerieEquipamento() {
        return serieEquipamento;
    }

    public void setSerieEquipamento(String serieEquipamento) {
        this.serieEquipamento = serieEquipamento;
    }

    public String getPatrimonio() {
        return patrimonio;
    }

    public void setPatrimonio(String patrimonio) {
        this.patrimonio = patrimonio;
    }

    public String getModelo() {
        return modelo;
    }

    public void setModelo(String modelo) {
        this.modelo = modelo;
    }

    public String getDepartamento() {
        return departamento;
    }

    public void setDepartamento(String departamento) {
        this.departamento = departamento;
    }

    public String getLocalInstalacao() {
        return localInstalacao;
    }

    public void setLocalInstalacao(String localInstalacao) {
        this.localInstalacao = localInstalacao;
    }

    public Long getIdBase() {
        return idBase;
    }

    public void setIdBase(Long idBase) {
        this.idBase = idBase;
    }

    public Integer getCountAtendimentosRealizados() {
        return countAtendimentosRealizados;
    }

    public void setCountAtendimentosRealizados(Integer countAtendimentosRealizados) {
        this.countAtendimentosRealizados = countAtendimentosRealizados;
    }

    public String getDataPrevisaoCompletaAsString() {
        return this.dataPrevisao + " " + this.horaPrevisao;
    }

    public String getDataInclusaoCompletaAsString() {
        return this.dataInclusao + " " + this.horaInclusao;
    }

    public String getClienteCompletoAsString() {
        return cdCliente + " - " + nmCliente;
    }

    public String getEnderecoCompletoAsString() {
        return endereco + " , " + complemento;
    }

    // find.getNumeroEnderecoCliente() + " " + find.getEnderecoCliente() + ", " + find.getCidadeCliente() + ", Brasil";
    public String getEnderecoGoogleMaps() {
        return endereco + ", " + cidade + ", Brasil";
    }

    public Boolean getAtivoApp() {
        return ativoApp;
    }

    public void setAtivoApp(Boolean ativoApp) {
        this.ativoApp = ativoApp;
    }

    public String getToolbarTitle() {
        return "Chamado "+ getIdChamadoWeb() + " / " + getSeqOS();
    }

    public StatusChamado getNovoStatusAposReiniciar() {
        return !isChamadoAtendido() && isChamadoAtrasado() ? StatusChamado.ATRASADOS : StatusChamado.LIBERADO_PARA_ATENDIMENTO;
    }

    private boolean isChamadoAtrasado() {
        Date dataPrevisao = getDataPrevisaoCompleta();
        Date instance = Calendar.getInstance().getTime();
        return dataPrevisao != null && instance.after(dataPrevisao);
    }

    @Nullable
    private Date getDataPrevisaoCompleta() {
        String data = dataPrevisao + " " + horaPrevisao;
        return DateUtils.parseData(data);
    }

    public boolean isChamadoAtendido() {
        return NumberUtils.INTEGER_ZERO < countAtendimentosRealizados;
    }

    public String getFollowUpTecnico() {
        return followUpTecnico;
    }

    public void setFollowUpTecnico(String followUpTecnico) {
        this.followUpTecnico = followUpTecnico;
    }
}
