package br.com.softilux.softiluxapp.data.db.model;

import android.os.Parcel;
import android.os.Parcelable;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

import br.com.softilux.softiluxapp.data.db.model.representation.StatusChamado;

/**
 * Created by Vinicius on 30,Janeiro,2019
 */
public class ChamadoFilterModel implements Parcelable {

    private Long numeroChamadoWeb;

    private Long numeroChamadoSistema;

    private String nomeCliente;

    private String serieEquipamento;

    private String statusChamado;

    public ChamadoFilterModel() {}

    public ChamadoFilterModel(Long numeroChamadoWeb, Long numeroChamadoSistema, String nomeCliente, String serieEquipamento, String statusChamado) {
        this.numeroChamadoWeb = numeroChamadoWeb;
        this.numeroChamadoSistema = numeroChamadoSistema;
        this.nomeCliente = nomeCliente;
        this.serieEquipamento = serieEquipamento;
        this.statusChamado = statusChamado;
    }

    protected ChamadoFilterModel(Parcel in) {
        if (in.readByte() == 0) {
            numeroChamadoWeb = null;
        } else {
            numeroChamadoWeb = in.readLong();
        }
        if (in.readByte() == 0) {
            numeroChamadoSistema = null;
        } else {
            numeroChamadoSistema = in.readLong();
        }
        nomeCliente = in.readString();
        serieEquipamento = in.readString();
        statusChamado = in.readString();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        if (numeroChamadoWeb == null) {
            dest.writeByte((byte) 0);
        } else {
            dest.writeByte((byte) 1);
            dest.writeLong(numeroChamadoWeb);
        }
        if (numeroChamadoSistema == null) {
            dest.writeByte((byte) 0);
        } else {
            dest.writeByte((byte) 1);
            dest.writeLong(numeroChamadoSistema);
        }
        dest.writeString(nomeCliente);
        dest.writeString(serieEquipamento);
        dest.writeString(statusChamado);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<ChamadoFilterModel> CREATOR = new Creator<ChamadoFilterModel>() {
        @Override
        public ChamadoFilterModel createFromParcel(Parcel in) {
            return new ChamadoFilterModel(in);
        }

        @Override
        public ChamadoFilterModel[] newArray(int size) {
            return new ChamadoFilterModel[size];
        }
    };

    public Long getNumeroChamadoWeb() {
        return numeroChamadoWeb;
    }

    public void setNumeroChamadoWeb(Long numeroChamadoWeb) {
        this.numeroChamadoWeb = numeroChamadoWeb;
    }

    public Long getNumeroChamadoSistema() {
        return numeroChamadoSistema;
    }

    public void setNumeroChamadoSistema(Long numeroChamadoSistema) {
        this.numeroChamadoSistema = numeroChamadoSistema;
    }

    public String getSerieEquipamento() {
        return serieEquipamento;
    }

    public void setSerieEquipamento(String serieEquipamento) {
        this.serieEquipamento = serieEquipamento;
    }

    public String getNomeCliente() {
        return nomeCliente;
    }

    public void setNomeCliente(String nomeCliente) {
        this.nomeCliente = nomeCliente;
    }

    public String getStatusChamado() {
        return statusChamado;
    }

    public StatusChamado getStatusChamadoAsEnum() {
        return StatusChamado.getEnumFromStatus(statusChamado);
    }

    public void setStatusChamado(String statusChamado) {
        this.statusChamado = statusChamado;
    }

    public boolean isPreenchido( ) {
        return StringUtils.isNotBlank(this.nomeCliente)
                || StringUtils.isNotBlank(this.serieEquipamento)
                || StringUtils.isNotBlank(this.statusChamado)
                || (this.numeroChamadoSistema != null && this.numeroChamadoSistema > 0)
                || (this.numeroChamadoWeb != null && this.numeroChamadoWeb > 0);
    }

    public boolean isSerieEquipamentoInformada() {
        return StringUtils.isNotBlank(this.getSerieEquipamento());
    }

    public boolean isNomeClienteInformado() {
        return StringUtils.isNotBlank(this.getNomeCliente());
    }

    public boolean isStatusChamadoInformado() {
        return StringUtils.isNotBlank(this.getStatusChamado());
    }

    public boolean isNumeroChamadoWebInformado() {
        return this.getNumeroChamadoWeb() != null && this.getNumeroChamadoWeb() > 0;
    }

    public boolean isNumeroChamadoSistemaInformado() {
        return this.getNumeroChamadoSistema() != null && this.getNumeroChamadoSistema() > 0;
    }
}
