package br.com.softilux.softiluxapp.data.db.model;

import android.arch.persistence.room.ColumnInfo;
import android.arch.persistence.room.Entity;
import android.arch.persistence.room.Ignore;
import android.arch.persistence.room.PrimaryKey;

import com.blankj.utilcode.util.TimeUtils;

import org.apache.commons.collections4.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import br.com.softilux.core.utils.DateUtils;
import br.com.softilux.core.utils.LoggerUtils;
import br.com.softilux.softiluxapp.transfer.datatransfer.NovoAtendimentoRequest;
import br.com.softilux.softiluxapp.transfer.datatransfer.TimelineRequest;
import br.com.softilux.softiluxapp.ui.chamado.AndamentoAtendimentoEnum;

/**
 * Created by Vinicius on 22,Maio,2019
 */
@Entity(tableName = "atendimentos")
public class AtendimentoModel extends AbstractCrudModel<NovoAtendimentoRequest> {

    @PrimaryKey(autoGenerate = true)
    @ColumnInfo(name = "id_app")
    private Long idApp;

    /**
     * id : 1781134
     * SEQOS : 1839729
     * ID_ATENDIMENTO : 17330
     * ID_ATENDIMENTO_ORIGEM : 0
     * NMATENDENTE : DEBORA
     * DATAHORA : 02/26/2019 08:53:04
     * DTATENDIMENTO : 2019-02-26
     * HRATENDIMENTO : 08:52:00
     * TEMPOATENDIMENTO : 1
     * OBSERVACAO : Abertura da O.S.
     * KMINICIAL : 0
     * KMFINAL : 0
     * CDMEDIDOR :
     * MEDIDOR : 0
     * MEDIDORDESC : 0
     * DTMEDIDORDESC : 0000-00-00
     * PLACAVEICULO :
     * HRATENDIMENTOFIN : 08:53:00
     * TFVISITA : N
     * ATUALIZADO_WEB : 2019-02-26 08:54:04
     * VALPEDAGIO : 0
     * VALESTACIONAMENTO : 0
     * VALOUTRASDESP : 0
     * TEMPOVIAGEM :
     * ATUALIZADO : 0
     * CAUSA :
     * SINTOMA :
     * ACAO :
     * VALATENDIMENTO : 0
     * VALKM : 0
     * HRVIAGEMINI :
     * HRVIAGEMFIN :
     * DTVIAGEMINI : 0000-00-00
     * DTVIAGEMFIN : 0000-00-00
     * OPCAOWEB : 0
     * chamado_id : null
     * empresa_id : 42
     * ID_BASE : 42
     */

    @ColumnInfo(name = "id_atendimento_portal")
    private Long idAtendimentoPortal;
    @ColumnInfo(name = "seq_os")
    private Long seqOs;
    @ColumnInfo(name = "id_atendimento_ilux")
    private Long idAtendimentoIlux;
    @ColumnInfo(name = "id_atendimento_origem")
    private Long idAtendimentoOrigem;
    @ColumnInfo(name = "nm_atendente")
    private String nomeAtendente;
    /**
     * Data/hora ao editar o chamado no portal
     * */
    @ColumnInfo(name = "data_hora_portal")
    private Date dtHoraPortal;
    @ColumnInfo(name = "data_atendimento")
    private Date dtAtendimento;
    @ColumnInfo(name = "hora_atendimento")
    private Date hrAtendimento;
    @ColumnInfo(name = "tempo_atendimento")
    private Integer tempoAtendimento;
    @ColumnInfo(name = "observacao")
    private String observacao;
    @ColumnInfo(name = "km_inicial")
    private Integer kmInicial;
    @ColumnInfo(name = "km_final")
    private Integer kmFinal;
    @ColumnInfo(name = "cd_medidor")
    private String cdMedidor;
    /**
     * Valor do medidor
     * */
    @ColumnInfo(name = "medidor")
    private Integer medidor;
    /**
     * Copias descontadas
     * */
    @ColumnInfo(name = "medidor_desc")
    private Integer medidorDesc;
    @ColumnInfo(name = "data_medidor_desc")
    private Date dtMedidorDesc;
    @ColumnInfo(name = "placa_veiculo")
    private String placaVeiculo;
    @ColumnInfo(name = "hr_atendimento_fim")
    private Date hrAtendimentoFim;
    @ColumnInfo(name = "tf_visita")
    private String tfVisita;
    @ColumnInfo(name = "data_atualizado_web")
    private Date dtAtualizadoWeb;
    @ColumnInfo(name = "valor_pedagio")
    private Double valorPedagio;
    @ColumnInfo(name = "valor_estacionamento")
    private Double valorEstacionamento;
    @ColumnInfo(name = "valor_outras_despesas")
    private Double valorOutrasDespesas;
    @ColumnInfo(name = "tempo_viagem")
    private String tempoViagem;
    @ColumnInfo(name = "atualizado_portal")
    private String atualizadoPortal;
    @ColumnInfo(name = "causa")
    private String causa;
    @ColumnInfo(name = "sintoma")
    private String sintoma;
    @ColumnInfo(name = "acao")
    private String acao;
    @ColumnInfo(name = "valor_atendimento")
    private Double valorAtendimento;
    @ColumnInfo(name = "valor_km")
    private Double valorKm;
    @ColumnInfo(name = "hora_viagem_inicial")
    private Date hrViagemInicial;
    @ColumnInfo(name = "hora_viagem_final")
    private Date hrViagemFinal;
    @ColumnInfo(name = "data_viagem_inicial")
    private Date dtViagemInicial;
    @ColumnInfo(name = "data_viagem_final")
    private Date dtViagemFinal;
    @ColumnInfo(name = "opcao_web")
    private String opcaoWeb;
    @ColumnInfo(name = "chamado_id")
    private Long chamadoId;
    @ColumnInfo(name = "empresa_id")
    private Long empresaId;
    @ColumnInfo(name = "id_base")
    private Long idBase;
    @ColumnInfo(name = "andamento_chamado_app")
    private AndamentoAtendimentoEnum andamentoChamadoApp;
    @ColumnInfo(name = "origem_cadastro")
    private String origemCadastro;
    @ColumnInfo(name = "ativoApp")
    private Boolean ativoApp;
    @ColumnInfo(name = "SINCRONIZADO_APP")
    private Boolean sincronizadoApp;
    @ColumnInfo(name = "ATUALIZADO_APP")
    private Date ultimaAtualizacaoApp;
    @ColumnInfo(name = "nome_contato")
    private String nomeContato;

    @Ignore
    private List<TimelineModel> timelines;

    @Ignore
    private List<AmazonFileModel> photos;

    public Long getIdApp() {
        return idApp;
    }

    public void setIdApp(Long idApp) {
        this.idApp = idApp;
    }

    public Long getIdAtendimentoPortal() {
        return idAtendimentoPortal;
    }

    public void setIdAtendimentoPortal(Long idAtendimentoPortal) {
        this.idAtendimentoPortal = idAtendimentoPortal;
    }

    public Long getSeqOs() {
        return seqOs;
    }

    public void setSeqOs(Long seqOs) {
        this.seqOs = seqOs;
    }

    public Long getIdAtendimentoIlux() {
        return idAtendimentoIlux;
    }

    public void setIdAtendimentoIlux(Long idAtendimentoIlux) {
        this.idAtendimentoIlux = idAtendimentoIlux;
    }

    public Long getIdAtendimentoOrigem() {
        return idAtendimentoOrigem;
    }

    public void setIdAtendimentoOrigem(Long idAtendimentoOrigem) {
        this.idAtendimentoOrigem = idAtendimentoOrigem;
    }

    public String getNomeAtendente() {
        return nomeAtendente;
    }

    public void setNomeAtendente(String nomeAtendente) {
        this.nomeAtendente = nomeAtendente;
    }

    public Date getDtHoraPortal() {
        return dtHoraPortal;
    }

    public void setDtHoraPortal(Date dtHoraPortal) {
        this.dtHoraPortal = dtHoraPortal;
    }

    public Date getDtAtendimento() {
        return dtAtendimento;
    }

    public void setDtAtendimento(Date dtAtendimento) {
        this.dtAtendimento = dtAtendimento;
    }

    public Date getHrAtendimento() {
        return hrAtendimento;
    }

    public void setHrAtendimento(Date hrAtendimento) {
        this.hrAtendimento = hrAtendimento;
    }

    public Integer getTempoAtendimento() {
        return tempoAtendimento;
    }

    public void setTempoAtendimento(Integer tempoAtendimento) {
        this.tempoAtendimento = tempoAtendimento;
    }

    public String getObservacao() {
        return observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    public Integer getKmInicial() {
        return kmInicial;
    }

    public void setKmInicial(Integer kmInicial) {
        this.kmInicial = kmInicial;
    }

    public Integer getKmFinal() {
        return kmFinal;
    }

    public void setKmFinal(Integer kmFinal) {
        this.kmFinal = kmFinal;
    }

    public String getCdMedidor() {
        return cdMedidor;
    }

    public void setCdMedidor(String cdMedidor) {
        this.cdMedidor = cdMedidor;
    }

    public Integer getMedidor() {
        return medidor;
    }

    public void setMedidor(Integer medidor) {
        this.medidor = medidor;
    }

    public Integer getMedidorDesc() {
        return medidorDesc;
    }

    public void setMedidorDesc(Integer medidorDesc) {
        this.medidorDesc = medidorDesc;
    }

    public Date getDtMedidorDesc() {
        return dtMedidorDesc;
    }

    public void setDtMedidorDesc(Date dtMedidorDesc) {
        this.dtMedidorDesc = dtMedidorDesc;
    }

    public String getPlacaVeiculo() {
        return placaVeiculo;
    }

    public void setPlacaVeiculo(String placaVeiculo) {
        this.placaVeiculo = placaVeiculo;
    }

    public Date getHrAtendimentoFim() {
        return hrAtendimentoFim;
    }

    public void setHrAtendimentoFim(Date hrAtendimentoFim) {
        this.hrAtendimentoFim = hrAtendimentoFim;
    }

    public String getTfVisita() {
        return tfVisita;
    }

    public void setTfVisita(String tfVisita) {
        this.tfVisita = tfVisita;
    }

    public Date getDtAtualizadoWeb() {
        return dtAtualizadoWeb;
    }

    public void setDtAtualizadoWeb(Date dtAtualizadoWeb) {
        this.dtAtualizadoWeb = dtAtualizadoWeb;
    }

    public Double getValorPedagio() {
        return valorPedagio;
    }

    public void setValorPedagio(Double valorPedagio) {
        this.valorPedagio = valorPedagio;
    }

    public Double getValorEstacionamento() {
        return valorEstacionamento;
    }

    public void setValorEstacionamento(Double valorEstacionamento) {
        this.valorEstacionamento = valorEstacionamento;
    }

    public Double getValorOutrasDespesas() {
        return valorOutrasDespesas;
    }

    public void setValorOutrasDespesas(Double valorOutrasDespesas) {
        this.valorOutrasDespesas = valorOutrasDespesas;
    }

    public String getTempoViagem() {
        return tempoViagem;
    }

    public void setTempoViagem(String tempoViagem) {
        this.tempoViagem = tempoViagem;
    }

    public String getAtualizadoPortal() {
        return atualizadoPortal;
    }

    public void setAtualizadoPortal(String atualizadoPortal) {
        this.atualizadoPortal = atualizadoPortal;
    }

    public String getCausa() {
        return causa;
    }

    public void setCausa(String causa) {
        this.causa = causa;
    }

    public String getSintoma() {
        return sintoma;
    }

    public void setSintoma(String sintoma) {
        this.sintoma = sintoma;
    }

    public String getAcao() {
        return acao;
    }

    public void setAcao(String acao) {
        this.acao = acao;
    }

    public Double getValorAtendimento() {
        return valorAtendimento;
    }

    public void setValorAtendimento(Double valorAtendimento) {
        this.valorAtendimento = valorAtendimento;
    }

    public Double getValorKm() {
        return valorKm;
    }

    public void setValorKm(Double valorKm) {
        this.valorKm = valorKm;
    }

    public Date getHrViagemInicial() {
        return hrViagemInicial;
    }

    public void setHrViagemInicial(Date hrViagemInicial) {
        this.hrViagemInicial = hrViagemInicial;
    }

    public Date getHrViagemFinal() {
        return hrViagemFinal;
    }

    public void setHrViagemFinal(Date hrViagemFinal) {
        this.hrViagemFinal = hrViagemFinal;
    }

    public Date getDtViagemInicial() {
        return dtViagemInicial;
    }

    public void setDtViagemInicial(Date dtViagemInicial) {
        this.dtViagemInicial = dtViagemInicial;
    }

    public Date getDtViagemFinal() {
        return dtViagemFinal;
    }

    public void setDtViagemFinal(Date dtViagemFinal) {
        this.dtViagemFinal = dtViagemFinal;
    }

    public String getOpcaoWeb() {
        return opcaoWeb;
    }

    public void setOpcaoWeb(String opcaoWeb) {
        this.opcaoWeb = opcaoWeb;
    }

    public Long getChamadoId() {
        return chamadoId;
    }

    public void setChamadoId(Long chamadoId) {
        this.chamadoId = chamadoId;
    }

    public Long getEmpresaId() {
        return empresaId;
    }

    public void setEmpresaId(Long empresaId) {
        this.empresaId = empresaId;
    }

    public Long getIdBase() {
        return idBase;
    }

    public void setIdBase(Long idBase) {
        this.idBase = idBase;
    }

    public AndamentoAtendimentoEnum getAndamentoChamadoApp() {
        return andamentoChamadoApp;
    }

    public void setAndamentoChamadoApp(AndamentoAtendimentoEnum andamentoChamadoApp) {
        this.andamentoChamadoApp = andamentoChamadoApp;
    }

    public String getOrigemCadastro() {
        return origemCadastro;
    }

    public void setOrigemCadastro(String origemCadastro) {
        this.origemCadastro = origemCadastro;
    }

    public List<TimelineModel> getTimelines() {
        if (timelines == null)
            timelines = new ArrayList<>();
        return timelines;
    }

    public void setTimelines(List<TimelineModel> timelines) {
        this.timelines = timelines;
    }

    public List<AmazonFileModel> getPhotos() {
        if (photos == null)
            photos = new ArrayList<>();
        return photos;
    }

    public void setPhotos(List<AmazonFileModel> photos) {
        this.photos = photos;
    }

    public Boolean getAtivoApp() {
        return ativoApp;
    }

    public void setAtivoApp(Boolean ativoApp) {
        this.ativoApp = ativoApp;
    }

    public Boolean getSincronizadoApp() {
        return sincronizadoApp;
    }

    public void setSincronizadoApp(Boolean sincronizadoApp) {
        this.sincronizadoApp = sincronizadoApp;
    }

    public Date getUltimaAtualizacaoApp() {
        return ultimaAtualizacaoApp;
    }

    public void setUltimaAtualizacaoApp(Date ultimaAtualizacaoApp) {
        this.ultimaAtualizacaoApp = ultimaAtualizacaoApp;
    }

    public String getNomeContato() {
        return nomeContato;
    }

    public void setNomeContato(String nomeContato) {
        this.nomeContato = nomeContato;
    }

    @Override
    public NovoAtendimentoRequest toRequest() {
        NovoAtendimentoRequest novoAtendimentoRequest = new NovoAtendimentoRequest();

        novoAtendimentoRequest.setIdBase(getIdBase());
        novoAtendimentoRequest.setAndamentoAtendimentoEnum(getAndamentoChamadoApp());
        novoAtendimentoRequest.setAtualizadoPortal(getAtualizadoPortal());
        novoAtendimentoRequest.setChamadoId(getChamadoId());
        novoAtendimentoRequest.setDtAtendimento(DateUtils.formatarDataEnvioJsonDtAtendimento(getDtAtendimento()));
        novoAtendimentoRequest.setDtHoraPortal(DateUtils.formatarDataHoraEnvioJson(getDtHoraPortal()));
        novoAtendimentoRequest.setHrAtendimento(DateUtils.formatarHoraMinutoSegundoEnvioJson(getHrAtendimento()));
        novoAtendimentoRequest.setNomeAtendente(getNomeAtendente());
        novoAtendimentoRequest.setOrigemCadastro(getOrigemCadastro());
        novoAtendimentoRequest.setSeqOs(getSeqOs());
        novoAtendimentoRequest.setEmpresaId(getEmpresaId());
        novoAtendimentoRequest.setTfVisita(getTfVisita());

        if (CollectionUtils.isNotEmpty(getTimelines())) {
            for (TimelineModel timelineModel:getTimelines()) {
                TimelineRequest timelineRequest = new TimelineRequest();
                timelineRequest.setIdBase(timelineModel.getIdBase());
                timelineRequest.setAndamentoSnapshot(timelineModel.getAndamentoSnapshot());
                timelineRequest.setCreateAt(DateUtils.formatYyyyMMddHHmmss(timelineModel.getCreateAt()));
                timelineRequest.setIdTecnico(timelineModel.getIdTecnico());
                timelineRequest.setTipoTimeLine(timelineModel.getTipoTimeLine());

                LocationCapture locationCapture = timelineModel.getLocationCapture();
                timelineRequest.setLocationCaptured(locationCapture.getLocationCaptured());
                LoggerUtils.info(locationCapture.toString());
                if (locationCapture.getLocationCaptured()) {
                    timelineRequest.setAddress(locationCapture.getAddress());
                    timelineRequest.setLatitute(locationCapture.getLatitute());
                    timelineRequest.setLongitute(locationCapture.getLongitute());
                    timelineRequest.setCountryName(locationCapture.getCountryName());
                    timelineRequest.setLocality(locationCapture.getLocality());
                }
                novoAtendimentoRequest.getTimelines().add(timelineRequest);
            }
        }
        return novoAtendimentoRequest;
    }

    public static AtendimentoModel iniciarNovoAtendimento(ChamadoModel chamadoModel) {
        AtendimentoModel atendimentoModel = new AtendimentoModel();

        atendimentoModel.setIdBase(chamadoModel.getIdBase());
        atendimentoModel.setChamadoId(chamadoModel.getIdChamadoWeb());
        atendimentoModel.setDtAtendimento(TimeUtils.getNowDate());
        atendimentoModel.setHrAtendimento(TimeUtils.getNowDate());
        atendimentoModel.setDtViagemInicial(TimeUtils.getNowDate());
        atendimentoModel.setNomeAtendente(chamadoModel.getNmSuporte());
        atendimentoModel.setDtHoraPortal(TimeUtils.getNowDate());
        atendimentoModel.setEmpresaId(chamadoModel.getEmpresaId());
        atendimentoModel.setSeqOs(chamadoModel.getSeqOS());
        atendimentoModel.setTfVisita("S");
        //Marcar que é um atendimento criado/alterado no portal para o softilux pegar este atendimento
        atendimentoModel.setAtualizadoPortal("1");
        atendimentoModel.setOrigemCadastro("APP_ANDROID");

        return atendimentoModel;
    }

    public String getToolbarTitle() {
        return "Atendimento " + getIdAtendimentoPortal();
    }

}
