package br.com.softilux.softiluxapp.data.db.model;

import android.arch.persistence.room.ColumnInfo;
import android.arch.persistence.room.Entity;
import android.arch.persistence.room.ForeignKey;
import android.arch.persistence.room.Index;
import android.arch.persistence.room.PrimaryKey;

import java.util.Date;
import java.util.logging.Logger;

import br.com.softilux.core.utils.DateUtils;
import br.com.softilux.core.utils.LoggerUtils;
import br.com.softilux.softiluxapp.data.db.model.representation.TipoFoto;
import br.com.softilux.softiluxapp.transfer.datatransfer.UploadPhotoResponse;

/**
 * Created by Vinicius on 22,Maio,2019
 */
@Entity(tableName = "photos_atendimento", foreignKeys = @ForeignKey(entity = AtendimentoModel.class,
        parentColumns = "id_app",
        childColumns = "id_atendimento_app",
        onDelete = ForeignKey.CASCADE)
    ,indices = @Index(name = "idx_atendimento_amazon_photo" , value = "id_atendimento_app"))
public class AmazonFileModel {

    @PrimaryKey(autoGenerate = true)
    @ColumnInfo(name = "id_app")
    private Long idApp;

    @ColumnInfo(name = "id_amazon_photo_portal")
    private Long idAmazonPhotoPortal;

    @ColumnInfo(name = "create_at")
    private Date createAt;

    @ColumnInfo(name = "id_atendimento_app")
    private Long idAtendimentoApp;

    @ColumnInfo(name = "id_atendimento_portal")
    private Long idAtendimentoPortal;

    @ColumnInfo(name = "id_base")
    private Long idBase;

    @ColumnInfo(name = "ATUALIZADO_APP")
    private Date atualizadoApp;

    @ColumnInfo(name = "amazon_id")
    private String amazonid;

    @ColumnInfo(name = "content_type")
    private String contentType;

    @ColumnInfo(name = "filename")
    private String filename;

    @ColumnInfo(name = "tipo_foto")
    private TipoFoto tipoFoto;

    public static AmazonFileModel gerarNovoAmazonFileFotoEquipamento(UploadPhotoResponse result, AtendimentoModel atendimentoModel) {
        AmazonFileModel amazonFileModel = new AmazonFileModel();
        amazonFileModel.setIdAmazonPhotoPortal(result.getId());
        amazonFileModel.setAmazonid(result.getAmazonid());
        amazonFileModel.setContentType(result.getContenttype());
        amazonFileModel.setFilename(result.getFilename());
        amazonFileModel.setIdAtendimentoApp(atendimentoModel.getIdApp());
        amazonFileModel.setIdBase(result.getId());
        amazonFileModel.setAtualizadoApp(DateUtils.parseData(result.getAtualizadoApp()));
        amazonFileModel.setCreateAt(DateUtils.parseData(result.getCreateAt()));
        LoggerUtils.info(result.getTipoFoto());
        amazonFileModel.setTipoFoto(TipoFoto.getEnum(result.getTipoFoto()));

        return amazonFileModel;
    }

    public Long getIdApp() {
        return idApp;
    }

    public void setIdApp(Long idApp) {
        this.idApp = idApp;
    }

    public Long getIdAmazonPhotoPortal() {
        return idAmazonPhotoPortal;
    }

    public void setIdAmazonPhotoPortal(Long idAmazonPhotoPortal) {
        this.idAmazonPhotoPortal = idAmazonPhotoPortal;
    }

    public Date getCreateAt() {
        return createAt;
    }

    public void setCreateAt(Date createAt) {
        this.createAt = createAt;
    }

    public Long getIdAtendimentoApp() {
        return idAtendimentoApp;
    }

    public void setIdAtendimentoApp(Long idAtendimentoApp) {
        this.idAtendimentoApp = idAtendimentoApp;
    }

    public Long getIdAtendimentoPortal() {
        return idAtendimentoPortal;
    }

    public void setIdAtendimentoPortal(Long idAtendimentoPortal) {
        this.idAtendimentoPortal = idAtendimentoPortal;
    }

    public Long getIdBase() {
        return idBase;
    }

    public void setIdBase(Long idBase) {
        this.idBase = idBase;
    }

    public Date getAtualizadoApp() {
        return atualizadoApp;
    }

    public void setAtualizadoApp(Date atualizadoApp) {
        this.atualizadoApp = atualizadoApp;
    }

    public String getAmazonid() {
        return amazonid;
    }

    public void setAmazonid(String amazonid) {
        this.amazonid = amazonid;
    }

    public String getContentType() {
        return contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getFilename() {
        return filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public TipoFoto getTipoFoto() {
        return tipoFoto;
    }

    public void setTipoFoto(TipoFoto tipoFoto) {
        this.tipoFoto = tipoFoto;
    }
}
