package br.com.softilux.softiluxapp.data.db;

import java.util.List;

import br.com.softilux.softiluxapp.data.db.model.Option;
import br.com.softilux.softiluxapp.data.db.model.Question;
import br.com.softilux.softiluxapp.data.db.model.User;
import io.reactivex.Observable;

public interface DbHelper {

    Observable<Long> insertUser(final User user);

    Observable<List<User>> getAllUsers();

    Observable<List<Question>> getAllQuestions();

    Observable<Boolean> isQuestionEmpty();

    Observable<Boolean> isOptionEmpty();

    Observable<Boolean> saveQuestion(Question question);

    Observable<Boolean> saveOption(Option option);

    Observable<Boolean> saveQuestionList(List<Question> questionList);

    Observable<Boolean> saveOptionList(List<Option> optionList);
}
