package br.com.softilux.softiluxapp.data.dao

import android.arch.persistence.db.SupportSQLiteQuery
import android.arch.persistence.room.Dao
import android.arch.persistence.room.Query
import android.arch.persistence.room.RawQuery
import br.com.softilux.softiluxapp.data.db.model.ChamadoModel
import br.com.softilux.softiluxapp.data.db.model.representation.StatusChamado

/**
 * Created by Vinicius on 30,Abril,2019
 */
@Dao
interface ChamadoDAO : BaseDAO<ChamadoModel> {

    @Query("SELECT * FROM chamados WHERE id_chamado_web = :id")
    fun findByIdChamadoWeb(id : Long) : ChamadoModel

    @Query("SELECT COUNT(id_app) FROM chamados WHERE id_chamado_web = :id")
    fun countByIdChamadoWeb(id : Long) : Int

    @Query("SELECT COUNT(id_app) FROM chamados WHERE status_app in (:filterStatus) ")
    fun countByStatusApp(filterStatus : List<String>) : Int

    @Query("SELECT * FROM chamados ORDER BY id_chamado_web DESC")
    fun getAll() : List<ChamadoModel>

    @Query("SELECT * FROM chamados where status_app = :filterStatus LIMIT 1")
    fun findFirstByStatusApp(filterStatus : String) : ChamadoModel

    @Query("SELECT * FROM chamados WHERE status_app in (:filterStatus) ORDER BY id_chamado_web DESC")
    fun findAllByStatusApp(filterStatus: List<String>): List<ChamadoModel>

    @Query("DELETE FROM chamados")
    fun deleteAll()

    @RawQuery
    fun getAllWithFilter(query : SupportSQLiteQuery) : List<ChamadoModel>

    @RawQuery
    fun countAllWithFilter(query : SupportSQLiteQuery) : Int

}