package br.com.softilux.softiluxapp.data.dao

import android.arch.persistence.room.*

@Dao
interface BaseDAO<T> {

    /**
     * Insert an object in the database.
     *
     * @param obj the object to be inserted.
     */
    @Insert(onConflict = OnConflictStrategy.REPLACE)
    fun insert(obj: T): Long

    /**
     * Insert an array of objects in the database.
     *
     * @param obj the objects to be inserted.
     */
    @Insert(onConflict = OnConflictStrategy.REPLACE)
    fun insert(vararg obj: T) : List<Long>

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    fun insertAll(obj: List<T>) : List<Long>

    /**
     * Update an object from the database.
     *
     * @param obj the object to be updated
     */
    @Update
    fun update(type: T)

    /**
     * Update an object from the database.
     *
     * @entity obj the object to be updated
     */
    @Update
    fun updateAll(vararg entity: T)

    /**
     * Delete an object from the database
     *
     * @param obj the object to be deleted
     */
    @Delete
    fun delete(type: T)


}