package br.com.softilux.softiluxapp.data.dao;

import android.arch.persistence.room.Database;
import android.arch.persistence.room.RoomDatabase;
import android.arch.persistence.room.TypeConverters;

import br.com.softilux.core.entities.Config;
import br.com.softilux.softiluxapp.data.db.model.AmazonFileModel;
import br.com.softilux.softiluxapp.data.db.model.AtendimentoModel;
import br.com.softilux.softiluxapp.data.db.model.ChamadoModel;
import br.com.softilux.softiluxapp.data.db.model.TimelineModel;
import br.com.softilux.softiluxapp.data.typeconverters.AndamentoAtendimentoConverter;
import br.com.softilux.softiluxapp.data.typeconverters.ChamadoStatusConverter;
import br.com.softilux.softiluxapp.data.typeconverters.DateConverters;
import br.com.softilux.softiluxapp.data.typeconverters.ModalidadeConverters;
import br.com.softilux.softiluxapp.data.typeconverters.StatusChamadoConverter;
import br.com.softilux.softiluxapp.data.typeconverters.TipoFotoConverter;
import br.com.softilux.softiluxapp.data.typeconverters.TipoInclusaoTimeLineConverter;

@Database(entities = {Config.class,
        ChamadoModel.class,
        AtendimentoModel.class,
        TimelineModel.class,
        AmazonFileModel.class},
        version = AppDatabase.VERSION)
@TypeConverters({DateConverters.class,
        ModalidadeConverters.class,
        StatusChamadoConverter.class,
        ChamadoStatusConverter.class,
        AndamentoAtendimentoConverter.class,
        TipoInclusaoTimeLineConverter.class,
        TipoFotoConverter.class})
public abstract class AppDatabase extends RoomDatabase {

    static final int VERSION = 1;

    public abstract ConfigDAO getConfigDAO();

    public abstract ChamadoDAO getChamadoDAO();

    public abstract AtendimentoDAO getAtendimentoDAO();

    public abstract TimelineDAO getTimelineDAO();

    public abstract AmazonPhotoDAO getAmazonPhotoDAO();

//    val MIGRATION_1_2: Migration = object: Migration(1, 2) {
//            override fun migrate(database: SupportSQLiteDatabase) {
//                database.execSQL("ALTER TABLE NewsWidget ADD COLUMN interval_anim INTEGER DEFAULT 6000")
//            }
//        }

}
