package br.com.softilux.softiluxapp;

import android.content.Intent;
import android.support.multidex.MultiDexApplication;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.interceptors.HttpLoggingInterceptor.Level;
import com.blankj.utilcode.util.Utils;
import com.crashlytics.android.Crashlytics;

import javax.inject.Inject;

import br.com.softilux.core.utils.LoggerUtils;
import br.com.softilux.softiluxapp.data.DataManager;
import br.com.softilux.softiluxapp.data.db.model.UsuarioLogado;
import br.com.softilux.softiluxapp.data.nosql.IPaperBook;
import br.com.softilux.softiluxapp.data.nosql.PaperBook;
import br.com.softilux.softiluxapp.di.component2.ApplicationComponent;
import br.com.softilux.softiluxapp.di.component2.DaggerApplicationComponent;
import br.com.softilux.softiluxapp.di.component2.ApplicationModule;
import br.com.softilux.softiluxapp.di.module.DatabaseModule;
import br.com.softilux.softiluxapp.service.LocationMonitoringService;
import io.fabric.sdk.android.Fabric;
import io.paperdb.Paper;
import uk.co.chrisjenx.calligraphy.CalligraphyConfig;

public class SoftiluxApp extends MultiDexApplication {

    @Inject
    DataManager mDataManager;

    @Inject
    CalligraphyConfig mCalligraphyConfig;

    private ApplicationComponent mApplicationComponent;

    @Inject
    PaperBook iPaperBook;

    @Override
    public void onCreate() {
        super.onCreate();

        mApplicationComponent = DaggerApplicationComponent.builder()
                .applicationModule(new ApplicationModule(this))
                .databaseModule(new DatabaseModule(this))
                .build();

        mApplicationComponent.inject(this);

        // Init Timber log
        LoggerUtils.init(BuildConfig.DEBUG);

        // Init Blank utilitys
        Utils.init(this);

        AndroidNetworking.initialize(getApplicationContext());
        if (BuildConfig.DEBUG) {
            AndroidNetworking.enableLogging(Level.BODY);
        }

        // Init paper nosql db
        Paper.init(this);

        Fabric.with(this, new Crashlytics());

        UsuarioLogado usuarioLogado = iPaperBook.getUsuarioLogado();
        if (usuarioLogado != null) {
            // TODO: Use the current user's information
            // You can call any combination of these three methods
            Crashlytics.setUserIdentifier(usuarioLogado.getIdTecnico() + "," + usuarioLogado.getIdEmpresa());
            Crashlytics.setUserEmail(usuarioLogado.getEmail());
            Crashlytics.setUserName(usuarioLogado.getNome());
        }

        startService(new Intent(this, LocationMonitoringService.class));

        //CalligraphyConfig.initDefault(mCalligraphyConfig);
    }

    public ApplicationComponent getComponent() {
        return mApplicationComponent;
    }

    // Needed to replace the component with a test specific one
    public void setComponent(ApplicationComponent applicationComponent) {
        mApplicationComponent = applicationComponent;
    }

}
